/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.deployer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.service.PortletDeploymentService;
import jp.sf.pal.admin.util.DeploymentUtil;
import jp.sf.pal.admin.web.AbstractPagerPage;

public class RemotePortletListPage extends AbstractPagerPage implements
        Serializable
{

    /**
     * 
     */
    private static final long serialVersionUID = -109222720193261550L;

    private String publisherName;

    private String artifactId;

    private String groupId;

    private String name;

    private String packaging;

    private int portletApplicationIndex;

    private List<Map<String, Object>> portletApplicationItems;

    private List<Map<String, String>> repositoryNameItems;

    private String repositoryName;

    private String version;

    private PortletDeploymentService portletDeploymentService;

    /**
     * @return the publisherName
     */
    public String getPublisherName()
    {
        return publisherName;
    }

    /**
     * @param publisherName the publisherName to set
     */
    public void setPublisherName(String publisherName)
    {
        this.publisherName = publisherName;
    }

    public String getArtifactId()
    {
        return artifactId;
    }

    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    }

    public String getGroupId()
    {
        return groupId;
    }

    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public String getPackaging()
    {
        return packaging;
    }

    public void setPackaging(String packaging)
    {
        this.packaging = packaging;
    }

    public int getPortletApplicationIndex()
    {
        return portletApplicationIndex;
    }

    public void setPortletApplicationIndex(int portletApplicationIndex)
    {
        this.portletApplicationIndex = portletApplicationIndex;
    }

    public List<Map<String, Object>> getPortletApplicationItems()
    {
        return portletApplicationItems;
    }

    public void setPortletApplicationItems(
            List<Map<String, Object>> portletApplicationItems)
    {
        this.portletApplicationItems = portletApplicationItems;
    }

    public List<Map<String, String>> getRepositoryNameItems()
    {
        return repositoryNameItems;
    }

    public void setRepositoryNameItems(List<Map<String, String>> repositoryItems)
    {
        this.repositoryNameItems = repositoryItems;
    }

    public String getVersion()
    {
        return version;
    }

    public void setVersion(String version)
    {
        this.version = version;
    }

    /**
     * @return the repositoryName
     */
    public String getRepositoryName()
    {
        return repositoryName;
    }

    /**
     * @param repositoryName the repositoryName to set
     */
    public void setRepositoryName(String repositoryName)
    {
        this.repositoryName = repositoryName;
    }

    /**
     * @return the portletDeploymentService
     */
    public PortletDeploymentService getPortletDeploymentService()
    {
        return portletDeploymentService;
    }

    /**
     * @param portletDeploymentService the portletDeploymentService to set
     */
    public void setPortletDeploymentService(
            PortletDeploymentService portletDeploymentService)
    {
        this.portletDeploymentService = portletDeploymentService;
    }

    public String initialize()
    {
        return null;
    }

    public String prerender()
    {
        getPortletDeploymentService().loadPage(this);

        return null;
    }

    public String doSelectRepository()
    {
        getPortletDeploymentService().updatePager(this);

        return null;
    }

    public boolean isDeploying()
    {
        return DeploymentUtil.isDeploying();
    }

}
