/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.deployer;

import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.service.RepositoryManagementService;
import jp.sf.pal.admin.web.AbstractPagerPage;

public class RemoteRepositoryListPage extends AbstractPagerPage
{

    private boolean available;

    private String name;

    private int repositoryIndex;

    private List<Map<String, Object>> repositoryItems;

    private RepositoryManagementService portletManagementService;

    /**
     * @return the available
     */
    public boolean isAvailable()
    {
        return available;
    }

    /**
     * @param available the available to set
     */
    public void setAvailable(boolean available)
    {
        this.available = available;
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public int getRepositoryIndex()
    {
        return repositoryIndex;
    }

    public void setRepositoryIndex(int portletApplicationIndex)
    {
        this.repositoryIndex = portletApplicationIndex;
    }

    public List<Map<String, Object>> getRepositoryItems()
    {
        return repositoryItems;
    }

    public void setRepositoryItems(
            List<Map<String, Object>> portletApplicationItems)
    {
        this.repositoryItems = portletApplicationItems;
    }

    /**
     * @return the portletManagementService
     */
    public RepositoryManagementService getRepositoryManagementService()
    {
        return portletManagementService;
    }

    /**
     * @param portletManagementService the portletManagementService to set
     */
    public void setRepositoryManagementService(
            RepositoryManagementService portletManagementService)
    {
        this.portletManagementService = portletManagementService;
    }

    public String initialize()
    {
        return null;
    }

    public String prerender()
    {
        getRepositoryManagementService().loadPage(this);
        
        return null;
    }

}
