/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.group;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.service.GroupManagementService;
import jp.sf.pal.admin.web.AbstractPagerPage;
import jp.sf.pal.admin.web.CrudType;

import org.seasar.teeda.extension.annotation.takeover.TakeOver;

public class GroupListPage extends AbstractPagerPage implements Serializable
{

    /**
     * 
     */
    private static final long serialVersionUID = 2827788757965933167L;

    private int groupIndex;

    private List<Map<String, Object>> groupItems;

    private String name;

    private GroupManagementService groupManagementService;

    public int getGroupIndex()
    {
        return groupIndex;
    }

    public void setGroupIndex(int groupIndex)
    {
        this.groupIndex = groupIndex;
    }

    public List<Map<String, Object>> getGroupItems()
    {
        return groupItems;
    }

    public void setGroupItems(List<Map<String, Object>> groupItems)
    {
        this.groupItems = groupItems;
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return the groupManagementService
     */
    public GroupManagementService getGroupManagementService()
    {
        return groupManagementService;
    }

    /**
     * @param groupManagementService the groupManagementService to set
     */
    public void setGroupManagementService(
            GroupManagementService groupManagementService)
    {
        this.groupManagementService = groupManagementService;
    }

    public String initialize()
    {
        return null;
    }

    public String prerender()
    {
        getGroupManagementService().loadPage(this);

        return null;
    }

    @TakeOver(properties = "crudType")
    public Class doCreate()
    {
        setCrudType(CrudType.CREATE);
        return GroupEditPage.class;
    }
}
