/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.portletmanager;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.service.PortletManagementService;
import jp.sf.pal.admin.web.AbstractPagerPage;

public class PortletListPage extends AbstractPagerPage implements Serializable
{

    /**
     * 
     */
    private static final long serialVersionUID = -4766951315413321520L;

    private String name;

    private String path;

    private int portletIndex;

    private List<Map<String, Object>> portletApplicationItems;

    private Integer status;

    private Integer applicationType;

    private String version;

    private boolean serverManagerAvailable;

    private PortletManagementService portletManagementService;

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public String getPath()
    {
        return path;
    }

    public void setPath(String path)
    {
        this.path = path;
    }

    public int getPortletIndex()
    {
        return portletIndex;
    }

    public void setPortletIndex(int portletIndex)
    {
        this.portletIndex = portletIndex;
    }

    public List<Map<String, Object>> getPortletApplicationItems()
    {
        return portletApplicationItems;
    }

    public void setPortletApplicationItems(
            List<Map<String, Object>> portletItems)
    {
        this.portletApplicationItems = portletItems;
    }

    public Integer getStatus()
    {
        return status;
    }

    public void setStatus(Integer status)
    {
        this.status = status;
    }

    /**
     * @return the applicationType
     */
    public Integer getApplicationType()
    {
        return applicationType;
    }

    /**
     * @param applicationType the applicationType to set
     */
    public void setApplicationType(Integer applicationType)
    {
        this.applicationType = applicationType;
    }

    public String getVersion()
    {
        return version;
    }

    public void setVersion(String version)
    {
        this.version = version;
    }

    /**
     * @return the serverManagerAvailable
     */
    public boolean isServerManagerAvailable()
    {
        return serverManagerAvailable;
    }

    /**
     * @param serverManagerAvailable the serverManagerAvailable to set
     */
    public void setServerManagerAvailable(boolean serverManagerAvailable)
    {
        this.serverManagerAvailable = serverManagerAvailable;
    }

    /**
     * @return the portletManagementService
     */
    public PortletManagementService getPortletManagementService()
    {
        return portletManagementService;
    }

    /**
     * @param portletManagementService the portletManagementService to set
     */
    public void setPortletManagementService(
            PortletManagementService portletManagementService)
    {
        this.portletManagementService = portletManagementService;
    }

    public String initialize()
    {
        return null;
    }

    public String prerender()
    {
        // load page
        getPortletManagementService().loadPage(this);

        return null;
    }

    public boolean isStartAction()
    {
        return isServerManagerAvailable()
                && getStatus() == PALAdminConstants.PORTLET_APPLICATION_STATUS_STOPPED
                && getApplicationType() == PALAdminConstants.PORTLET_APPLICATION_TYPE_WEBAPP;
    }

    public boolean isStopAction()
    {
        return isServerManagerAvailable()
                && getStatus() == PALAdminConstants.PORTLET_APPLICATION_STATUS_RUNNING
                && getApplicationType() == PALAdminConstants.PORTLET_APPLICATION_TYPE_WEBAPP;
    }

    public boolean isUndeployAction()
    {
        return isServerManagerAvailable()
                && getApplicationType() == PALAdminConstants.PORTLET_APPLICATION_TYPE_WEBAPP;
    }

    public boolean isDeleteAction()
    {
        return getStatus() == PALAdminConstants.PORTLET_APPLICATION_STATUS_STOPPED;
    }

    public boolean isRunning()
    {
        return getStatus() == PALAdminConstants.PORTLET_APPLICATION_STATUS_RUNNING;
    }

    public boolean isStopped()
    {
        return getStatus() == PALAdminConstants.PORTLET_APPLICATION_STATUS_STOPPED;
    }

    public boolean isUnknown()
    {
        return !isRunning() && !isStopped();
    }

}
