/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.user;

import jp.sf.pal.admin.service.UserManagementService;
import jp.sf.pal.admin.web.AbstractCrudPage;

import org.seasar.teeda.extension.annotation.validator.Required;

public class AbstractUserPage extends AbstractCrudPage
{

    private String name;

    private String password;

    private boolean updateRequired;

    private String roleName;

    private UserManagementService userManagementService;

    public AbstractUserPage()
    {
        super();
    }

    public String getName()
    {
        return name;
    }

    @Required
    public void setName(String userName)
    {
        this.name = userName;
    }

    /**
     * @return the password
     */
    public String getPassword()
    {
        return password;
    }

    /**
     * @param password the password to set
     */
    @Required
    public void setPassword(String password)
    {
        this.password = password;
    }

    /**
     * @return the role
     */
    public String getRoleName()
    {
        return roleName;
    }

    /**
     * @param role the role to set
     */
    @Required
    public void setRoleName(String role)
    {
        this.roleName = role;
    }

    /**
     * @return the updateRequired
     */
    public boolean isUpdateRequired()
    {
        return updateRequired;
    }

    /**
     * @param updateRequired the updateRequired to set
     */
    public void setUpdateRequired(boolean updateRequired)
    {
        this.updateRequired = updateRequired;
    }

    /**
     * @return the userManagementService
     */
    public UserManagementService getUserManagementService()
    {
        return userManagementService;
    }

    /**
     * @param userManagementService the userManagementService to set
     */
    public void setUserManagementService(
            UserManagementService userManagementService)
    {
        this.userManagementService = userManagementService;
    }

}