/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.user;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import javax.faces.internal.FacesMessageUtil;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.service.UserManagementService;
import jp.sf.pal.admin.web.AbstractPagerPage;
import jp.sf.pal.admin.web.CrudType;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;

public class UserListPage extends AbstractPagerPage implements Serializable
{

    /**
     * 
     */
    private static final long serialVersionUID = 1803281059596051705L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger.getLogger(UserListPage.class);

    private String name;

    private String filter;

    private int userIndex;

    private List<Map<String, Object>> userItems;

    private UserManagementService userManagementService;

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return the filter
     */
    public String getFilter()
    {
        return filter;
    }

    /**
     * @param filter the filter to set
     */
    public void setFilter(String filter)
    {
        this.filter = filter;
    }

    public int getUserIndex()
    {
        return userIndex;
    }

    public void setUserIndex(int userIndex)
    {
        this.userIndex = userIndex;
    }

    public List<Map<String, Object>> getUserItems()
    {
        return userItems;
    }

    public void setUserItems(List<Map<String, Object>> userItems)
    {
        this.userItems = userItems;
    }

    /**
     * @return the userManagementService
     */
    public UserManagementService getUserManagementService()
    {
        return userManagementService;
    }

    /**
     * @param userManagementService the userManagementService to set
     */
    public void setUserManagementService(
            UserManagementService userManagementService)
    {
        this.userManagementService = userManagementService;
    }

    public String initialize()
    {
        return null;
    }

    public String prerender()
    {
        try
        {
            userManagementService.loadPage(this);
        }
        catch (PALAdminException e)
        {
            FacesMessageUtil.addErrorMessage("failed.to.get.users");
            logger.error("Failed to add a new user: " + getName(), e);
        }

        return null;
    }

    @TakeOver(properties = "crudType")
    public Class doCreate()
    {
        setCrudType(CrudType.CREATE);
        return UserCreatePage.class;
    }

    public Class doSearch()
    {
        getUserManagementService().updateQuery(this);
        return null;
    }

    public Class doResetSearch()
    {
        setFilter("");
        getUserManagementService().updateQuery(this);
        return null;
    }
}
