/*
 * Copyright 2005-2006 Portal Application Laboratory project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.jsf.custom.fileupload;

import javax.faces.component.UIComponent;

import jp.sf.pal.jsf.JsfConstants;

import org.seasar.teeda.core.taglib.html.InputTagBase;

public class HtmlInputFileUploadTag extends InputTagBase {

    public String getComponentType() {
        return HtmlInputFileUpload.COMPONENT_TYPE;
    }

    public String getRendererType() {
        return HtmlInputFileUpload.DEFAULT_RENDERER_TYPE;
    }

    private String accesskey;

    private String align;

    private String alt;

    private String datafld;

    private String datasrc;

    private String dataformatas;

    private String disabled;

    private String maxlength;

    private String onblur;

    private String onchange;

    private String onfocus;

    private String onselect;

    private String readonly;

    private String size;

    private String tabindex;

    private String accept;

    private String storage;

    public void release() {
        super.release();
        accesskey = null;
        align = null;
        alt = null;
        datafld = null;
        datasrc = null;
        dataformatas = null;
        disabled = null;
        maxlength = null;
        onblur = null;
        onchange = null;
        onfocus = null;
        onselect = null;
        readonly = null;
        size = null;
        tabindex = null;
        accept = null;
        storage = null;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);

        setComponentProperty(component, JsfConstants.ACCESSKEY_ATTR, accesskey);
        setComponentProperty(component, JsfConstants.ALIGN_ATTR, align);
        setComponentProperty(component, JsfConstants.ALT_ATTR, alt);
        setComponentProperty(component, JsfConstants.DATAFLD_ATTR, datafld);
        setComponentProperty(component, JsfConstants.DATASRC_ATTR, datasrc);
        setComponentProperty(component, JsfConstants.DATAFORMATAS_ATTR,
                dataformatas);
        setComponentProperty(component, JsfConstants.DISABLED_ATTR, disabled);
        setComponentProperty(component, JsfConstants.MAXLENGTH_ATTR, maxlength);
        setComponentProperty(component, JsfConstants.ONBLUR_ATTR, onblur);
        setComponentProperty(component, JsfConstants.ONCHANGE_ATTR, onchange);
        setComponentProperty(component, JsfConstants.ONFOCUS_ATTR, onfocus);
        setComponentProperty(component, JsfConstants.ONSELECT_ATTR, onselect);
        setComponentProperty(component, JsfConstants.READONLY_ATTR, readonly);
        setComponentProperty(component, JsfConstants.SIZE_ATTR, size);
        setComponentProperty(component, JsfConstants.TABINDEX_ATTR, tabindex);

        setComponentProperty(component, JsfConstants.ACCEPT_ATTR, accept);
        setComponentProperty(component, JsfConstants.STORAGE_ATTR, storage);

    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public void setDatafld(String datafld) {
        this.datafld = datafld;
    }

    public void setDatasrc(String datasrc) {
        this.datasrc = datasrc;
    }

    public void setDataformatas(String dataformatas) {
        this.dataformatas = dataformatas;
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    public void setOnblur(String onblur) {
        this.onblur = onblur;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }

    public void setOnselect(String onselect) {
        this.onselect = onselect;
    }

    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setTabindex(String tabindex) {
        this.tabindex = tabindex;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

}
