/*
 * Copyright 2004-2006 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.wcm.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.pal.wcm.PALWcmConstants;
import jp.sf.pal.wcm.util.PALWcmUtil;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author shinsuke
 *
 */
public class FileuploadServlet extends HttpServlet
{

    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(FileuploadServlet.class);

    /**
     * Serial Version UID
     */
    private static final long serialVersionUID = 2542877848615221862L;

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        printResponse(resp.getWriter(), HttpServletResponse.SC_NOT_IMPLEMENTED,
                "", "", "GET method is not supported.");
    }

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        // check login
        //        if (req.getRemoteUser() == null)
        if (req.getSession().getAttribute(PALWcmConstants.LOGIN_USER_NAME) == null)
        {
            printResponse(resp.getWriter(), HttpServletResponse.SC_FORBIDDEN,
                    "", "", "Please login to Portal.");
            return;
        }

        // check namespace
        String namespace = req
                .getParameter(PALWcmConstants.NAMESPACE_SERVLET_PARAM);
        if (namespace == null)
        {
            printResponse(resp.getWriter(), HttpServletResponse.SC_BAD_REQUEST,
                    "", "",
                    "Invalid parameters. You needs to specify a namespace.");
            return;
        }

        String type = req.getParameter(PALWcmConstants.TYPE_SERVLET_PARAM);
        if (type == null)
        {
            printResponse(resp.getWriter(), HttpServletResponse.SC_BAD_REQUEST,
                    "", "", "Invalid parameters. You needs to specify a type.");
            return;
        }

        try
        {
            //          Create a factory for disk-based file items
            FileItemFactory factory = new DiskFileItemFactory();

            //             Create a new file upload handler
            ServletFileUpload upload = new ServletFileUpload(factory);

            //             Parse the request
            List /* FileItem */items = upload.parseRequest(req);

            Iterator ite = items.iterator();
            while (ite.hasNext())
            {
                FileItem item = (FileItem) ite.next();
                if (!item.isFormField())
                {
                    String clientFullFileName = item.getName();
                    clientFullFileName = clientFullFileName.replace('\\', '/');
                    String[] pathParts = clientFullFileName.split("/");
                    String fileName = pathParts[pathParts.length - 1];

                    String baseUploadDir = PALWcmUtil
                            .getBaseUploadDir(getServletContext());
                    PALWcmUtil.checkUploadDir(baseUploadDir, namespace, type);

                    String storeFileName = baseUploadDir + "/" + namespace
                            + "/" + type + "/" + fileName;
                    item.write(new File(storeFileName));

                    String fileUrl = req.getContextPath() + "/fileview?"
                            + PALWcmConstants.NAMESPACE_SERVLET_PARAM + "="
                            + namespace + "&"
                            + PALWcmConstants.TYPE_SERVLET_PARAM + "=" + type
                            + "&" + PALWcmConstants.NAME_SERVLET_PARAM + "="
                            + fileName;

                    printResponse(resp.getWriter(), /*HttpServletResponse.SC_OK*/
                    0, fileUrl, fileName, "");
                    return;
                }
            }
        }
        catch (Exception e)
        {
            printResponse(resp.getWriter(),
                    HttpServletResponse.SC_INTERNAL_SERVER_ERROR, "", "",
                    "Internal server error. ");
            log.error("Internal server error.", e);
        }

        printResponse(resp.getWriter(),
                HttpServletResponse.SC_SERVICE_UNAVAILABLE, "", "",
                "Could not find an upload file.");

    }

    protected void printResponse(PrintWriter writer, int retVal,
            String fileUrl, String fileName, String errorMessage)
    {
        writer.print("<script type=\"text/javascript\">\n"
                + "window.parent.OnUploadCompleted( " + retVal + ", '"
                + fileUrl + "', '" + fileName + "','" + errorMessage + "') ;\n"
                + "</script>");
    }

}
