/*
 * Copyright 2004-2006 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.wcm.util;

import java.io.File;

import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

import jp.sf.pal.wcm.PALWcmConstants;

/**
 * @author shinsuke
 *
 */
public class PALWcmUtil
{
    public static String getMimeType(Object context, String filename)
    {
        if (context instanceof ServletContext)
        {
            ServletContext servletContext = (ServletContext) context;
            return servletContext.getMimeType(filename);
        }
        else if (context instanceof PortletContext)
        {
            PortletContext portletContext = (PortletContext) context;
            return portletContext.getMimeType(filename);
        }
        return null;
    }

    public static String getBaseUploadDir(ServletContext servletContext)
    {
        String uploadDir = servletContext
                .getInitParameter(PALWcmConstants.UPLOAD_DIRECTORY_PARAM);
        if (uploadDir == null)
        {
            uploadDir = servletContext
                    .getRealPath(PALWcmConstants.DEFAULT_UPLOAD_DIR);
        }
        return uploadDir;
    }

    public static boolean checkUploadDir(String baseDir, String namespace,
            String type)
    {
        File baseUploadDir = new File(baseDir);
        if (!baseUploadDir.exists())
        {
            if (!baseUploadDir.mkdir())
            {
                return false;
            }
        }

        File namespaceDir = new File(baseDir + "/" + namespace);
        if (!namespaceDir.exists())
        {
            if (!namespaceDir.mkdir())
            {
                return false;
            }
        }

        File typeDir = new File(namespaceDir, type);
        if (!typeDir.exists())
        {
            if (!typeDir.mkdir())
            {
                return false;
            }
        }

        return true;
    }
}
