<%--
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
--%>
<%@ taglib uri="http://java.sun.com/portlet" prefix="portlet" %>
<%@ taglib uri="http://java.sun.com/jstl/fmt" prefix="fmt" %>
<%@ page import="jp.sf.pal.wcm.PALWcmConstants"%>
<portlet:defineObjects/>

<portlet:renderURL var="closeUrl" portletMode="view"></portlet:renderURL>
<portlet:renderURL var="contentEditUrl" portletMode="edit">
  <portlet:param name="jp.sf.pal.wcm.EditType" value="jp.sf.pal.wcm.ContentEditType"/>
</portlet:renderURL>

<div style="z-index:10000;border-left:1px solid #999999;border-top:1px solid #999999;border-bottom:4px solid #999999;border-right:4px solid #999999;width:750px;height:500px;position:absolute; top:30px; left:30px;background-color:white;">
  <form id="<portlet:namespace/>PreferencesForm" action="<portlet:actionURL />" method="POST"><input type="hidden" name="<%= PALWcmConstants.ACTION_TYPE %>"/>
  <input type="hidden" name="<%= PALWcmConstants.EDIT_TYPE %>" value="<%= PALWcmConstants.PREFERENCES_EDIT_TYPE %>"/>
  <input type="hidden" name="<%= PALWcmConstants.FRAGMENT_ID %>" 
    value="<%= renderRequest.getAttribute(PALWcmConstants.FRAGMENT_ID) %>"/>
  <div style="width:100%;height:20px;background-color:#efefde;border-bottom:1px solid #999999;">
    <div style="float:left;height:20px;font-size:10pt;font-family:sans-serif;color:#666666;padding-left:5px;">
      Preferences
    </div>
    <div style="float:right;height:20px">
      <a href="<%= contentEditUrl %>"><img src="<%= renderRequest.getContextPath() %>/images/icons/page_edit.png" alt="Preferences" style="border: 0px;"/></a>
      <a href="<%= closeUrl %>"><img src="<%= renderRequest.getContextPath() %>/images/icons/cross.png" alt="Close" style="border: 0px;"/></a>
    </div>
  </div>
  
  <div style="clear:both;">

  <span><%= renderRequest.getAttribute(PALWcmConstants.MESSAGE) %></span>

  <div style="margin:10px;">

  <div style="font-size:10pt;font-family:sans-serif;pading:5px;">
    <h3>Language</h3>
    <div>
      <label for="<portlet:namespace/>TargetLocale">Locale</label>
      <input type="text" id="<portlet:namespace/>TargetLocale" name="<%= PALWcmConstants.TARGET_LOCALE %>" size="10"/>
      <button type="submit" onclick="this.form.firstChild.value='<%= PALWcmConstants.ADD_LOCALE %>';"><img style="vertical-align:middle;" src="<%= renderRequest.getContextPath() %>/images/icons/add.png"/>Add</button>
      <br/>
      <span style="color:#999999;">The format of Locale is xx_XX(ex. ja_JP).</span>
    </div>
    <br/>
    <div>
      <label for="<portlet:namespace/>SelectedLocale">Locale List</label><br/>
      <select style="width:150px;" size="5" id="<portlet:namespace/>SelectedLocale" name="<%= PALWcmConstants.SELECTED_LOCALE %>">
        <%= renderRequest.getAttribute(PALWcmConstants.LOCALE_LIST) %>
      </select>
      <button type="submit" onclick="this.form.firstChild.value='<%= PALWcmConstants.DELETE_LOCALE %>';"><img style="vertical-align:middle;" src="<%= renderRequest.getContextPath() %>/images/icons/delete.png"/>Delete</button>
    </div>
  </div>

  </div>
  
  </form>
</div>
