/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin;

import org.apache.jetspeed.om.folder.Folder;

public class PALAdminConstants {
    public static final boolean DEBUG = false;

    public static final String PREFIX = "jp.sf.pal.admin.";

    public static final String CPS_SECURITY_PROVIDER_COMPONENT = "cps:SecurityProvider";

    public static final String SECURITY_PROVIDER_COMPONENT = PREFIX
            + "SecurityProvider";

    public static final String PORTAL_ADMINISTRATION_COMPONENT = PREFIX
            + "PortalAdministration";

    public static final String USER_MANAGER_COMPONENT = PREFIX + "UserManager";

    public static final String ROLE_MANAGER_COMPONENT = PREFIX + "RoleManager";

    public static final String GROUP_MANAGER_COMPONENT = PREFIX
            + "GroupManager";

    public static final String PROFILER_COMPONENT = PREFIX + "Profiler";

    public static final String PAGE_MANAGER_COMPONENT = PREFIX + "PageManager";

    public static final String APPLICATION_SERVER_MANAGER_COMPONENT = PREFIX
            + "ApplicationServerManager";

    public static final String PORTLET_REGISTRY_COMPONENT = PREFIX
            + "PortletRegistry";

    public static final String PERMISSION_MANAGER_COMPONENT = PREFIX
            + "PermissionManager";

    public static final String PORTLET_ENTITY_ACCESS_COMPONENT = PREFIX
            + "PortletEntityAccess";

    public static final String PORTLET_WINDOW_ACCESSOR_COMPONENT = PREFIX
            + "PortletWindowAccessor";

    public static final String SECURITY_ACCESS_CONTROLLER_COMPONENT = PREFIX
            + "SecurityAccessController";

    public static final String PORTLET_FACTORY_COMPONENT = PREFIX
            + "PortletFactory";

    public static final String DEPLOYMENT_MANAGER_COMPONENT = PREFIX
            + "DeploymentManager";

    public static final String DECORATION_FACTORY_COMPONENT = PREFIX
            + "DecorationFactory";

    public static final String PREVIOUS_PAGE_NUMBER = "previousPageNumber";

    public static final String NEXT_PAGE_NUMBER = "nextPageNumber";

    //TODO move to portlet.xml file
    public static final int DEFAULT_PAGER_LIMIT_SIZE = 25;

    public static final String DEFAULT_USER_TEMPLATE_FOLDER_NAME = "_template";

    public static final String DEFAULT_USER_TEMPLATE_FOLDER = Folder.USER_FOLDER
            + DEFAULT_USER_TEMPLATE_FOLDER_NAME + "/";

    public static final String USER_CREDENTIAL_ACTIVE = PREFIX + "Active";

    public static final String USER_CREDENTIAL_EXPIRED = PREFIX + "Expired";

    public static final String USER_CREDENTIAL_EXTEND = PREFIX + "Extend";

    public static final String USER_CREDENTIAL_EXTEND_UNLIMITED = PREFIX
            + "ExtendUnlimited";

    //TODO move to portlet.xml file
    public static final String LOCATOR_PAGE = "page";

    //TODO move to portlet.xml file
    public static final String LOCATOR_MENU = "menu";

    public static final int PORTLET_APPLICATION_TYPE_WEBAPP = 0;

    public static final int PORTLET_APPLICATION_TYPE_LOCAL = 1;

    public static final int PORTLET_APPLICATION_STATUS_RUNNING = 1;

    public static final int PORTLET_APPLICATION_STATUS_STOPPED = 0;

    public static final String PORTLET_MANAGEMENT_ACTION_START = "start";

    public static final String PORTLET_MANAGEMENT_ACTION_STOP = "stop";

    public static final String PORTLET_MANAGEMENT_ACTION_UNDEPLOY = "undeploy";

    public static final String PORTLET_MANAGEMENT_ACTION_DELETE = "delete";

    public static final String DEPLOYMENT_STATUS = PREFIX + "DeploymentStatus";

    public static final String LOCAL_TEMP_FILENAME_PREFIX = "uploadedPortletApplication";

    public static final String LOCAL_TEMP_FILENAME_SUFFIX = ".war";

    public static final String PASSWORD = PREFIX + "Password";

    public static final String ROLES = PREFIX + "Roles";

    public static final String GROUPS = PREFIX + "Groups";

    public static final String RULES = PREFIX + "Rules";

    public static final String RULE_NAMES = PREFIX + "RuleNames";

    public static final String RULE_VALUES = PREFIX + "RuleValues";

    public static final String EMAIL_TEMPLATE_LOCATION = PREFIX
            + "EmailTemplateLocation";

    public static final String EMAIL_TEMPLATE_NAME = PREFIX
            + "EmailTemplateName";

    public static final String TEMPLATE_LOCATOR = PREFIX + "TemplateLocator";

    public static final String FORCE_UNIQUE_EMAIL = PREFIX + "ForceUniqueEmail";

    public static final String FORCE_GENERATED_PASSWORD = PREFIX
            + "ForceGeneratedPassword";

    public static final String FORCE_USE_EMAIL_AS_USERNAME = PREFIX
            + "ForceUseEmailAsUsername";

    public static final String SEND_MAIL = PREFIX + "SendMail";

    public static final String RETURN_PATH = PREFIX + "ReturnPath";

    public static final String USER_REGISTRATION_PARAMS = PREFIX
            + "UserRegistrationParams";

    public static final String DEFAULT_TEMPLATE_LOCATION = "/WEB-INF/template/userreg/";

    public static final String DEFAULT_TEMPLATE_NAME = "userRegistrationEmail.vm";

    public static final String CTX_RETURN_URL = "returnURL";

    public static final String SEPARATOR = "::";

    public static final String SECRET_ANSWER_DISPLAY = "*****************";

    public static final String SECURITY_CONSTRAINT = "securityConstraint";

    public static final String SECURITY_CONSTRAINTS_REF = "securityConstraintsRef";

    public static final String SECURITY_CONSTRAINT_NAME = "securityConstraintName";

    public static final String SECURITY_CONSTRAINT_TYPE = "securityConstraintType";

    public static final String SECURITY_CONSTRAINT_PERMISSION = "securityConstraintPermission";

    public static final String SECURITY_CONSTRAINT_ORDER = "applyOrder";
}
