/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.filter;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import jp.sf.pal.admin.PALAdminConstants;

import org.apache.jetspeed.CommonPortletServices;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityProvider;
import org.apache.jetspeed.security.UserManager;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

public class UserManagementFilter implements PortletFilter
{
    private SecurityProvider securityProvider;

    private UserManager userManager;

    private GroupManager groupManager;

    private RoleManager roleManager;

    private Profiler profiler;

    private PageManager pageManager;

    /*
     * (non-Javadoc)
     *
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#destroy()
     */
    public void destroy()
    {
        securityProvider = null;
        userManager = null;
        groupManager = null;
        roleManager = null;
        profiler = null;
        pageManager = null;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#init(org.apache.portals.bridges.portletfilter.PortletFilterConfig)
     */
    public void init(PortletFilterConfig filterConfig) throws PortletException
    {
        PortletConfig portletConfig = filterConfig.getPortletConfig();
        PortletContext portletContext = portletConfig.getPortletContext();
        if (!PALAdminConstants.DEBUG)
        {
            // securityProvider
            securityProvider = (SecurityProvider) portletContext.getAttribute(PALAdminConstants.CPS_SECURITY_PROVIDER_COMPONENT);
            if (securityProvider == null)
            {
                throw new PortletException("Failed to find the Security Provider on portlet initialization");
            }

            // userManager
            userManager = (UserManager) portletContext.getAttribute(CommonPortletServices.CPS_USER_MANAGER_COMPONENT);
            if (userManager == null)
            {
                throw new PortletException("Failed to find the User Manager on portlet initialization");
            }

            // groupManager
            groupManager = (GroupManager) portletContext.getAttribute(CommonPortletServices.CPS_GROUP_MANAGER_COMPONENT);
            if (groupManager == null)
            {
                throw new PortletException("Failed to find the Group Manager on portlet initialization");
            }

            // roleManager
            roleManager = (RoleManager) portletContext.getAttribute(CommonPortletServices.CPS_ROLE_MANAGER_COMPONENT);
            if (roleManager == null)
            {
                throw new PortletException("Failed to find the Role Manager on portlet initialization");
            }

            // profiler
            profiler = (Profiler) portletContext.getAttribute(CommonPortletServices.CPS_PROFILER_COMPONENT);
            if (null == profiler)
            {
                throw new PortletException("Failed to find the Profiler on portlet initialization");
            }

            // pageManager
            pageManager = (PageManager) portletContext.getAttribute(CommonPortletServices.CPS_PAGE_MANAGER_COMPONENT);
            if (null == pageManager)
            {
                throw new PortletException("Failed to find the Page Manager on portlet initialization");
            }

        }
    }

    /*
     * (non-Javadoc)
     *
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#processActionFilter(javax.portlet.ActionRequest,
     *      javax.portlet.ActionResponse,
     *      org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain)
            throws PortletException, IOException
    {
        request.setAttribute(PALAdminConstants.SECURITY_PROVIDER_COMPONENT, securityProvider);
        request.setAttribute(PALAdminConstants.USER_MANAGER_COMPONENT, userManager);
        request.setAttribute(PALAdminConstants.GROUP_MANAGER_COMPONENT, groupManager);
        request.setAttribute(PALAdminConstants.ROLE_MANAGER_COMPONENT, roleManager);
        request.setAttribute(PALAdminConstants.PROFILER_COMPONENT, profiler);
        request.setAttribute(PALAdminConstants.PAGE_MANAGER_COMPONENT, pageManager);

        chain.processActionFilter(request, response);
    }

    /*
     * (non-Javadoc)
     *
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#renderFilter(javax.portlet.RenderRequest,
     *      javax.portlet.RenderResponse,
     *      org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain) throws PortletException,
            IOException
    {
        request.setAttribute(PALAdminConstants.SECURITY_PROVIDER_COMPONENT, securityProvider);
        request.setAttribute(PALAdminConstants.USER_MANAGER_COMPONENT, userManager);
        request.setAttribute(PALAdminConstants.GROUP_MANAGER_COMPONENT, groupManager);
        request.setAttribute(PALAdminConstants.ROLE_MANAGER_COMPONENT, roleManager);
        request.setAttribute(PALAdminConstants.PROFILER_COMPONENT, profiler);
        request.setAttribute(PALAdminConstants.PAGE_MANAGER_COMPONENT, pageManager);

        chain.renderFilter(request, response);
    }

}
