/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.service;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.deployer.PortletDeployer;
import jp.sf.pal.admin.dxo.PortletApplicationDxo;
import jp.sf.pal.admin.entity.PortletApplication;
import jp.sf.pal.admin.logic.PortletDeploymentLogic;
import jp.sf.pal.admin.logic.PortletManagementLogic;
import jp.sf.pal.admin.logic.RepositoryManagementLogic;
import jp.sf.pal.admin.pager.RemotePortletApplicationPager;
import jp.sf.pal.admin.rpad.repository.Repository;
import jp.sf.pal.admin.util.PALAdminUtil;
import jp.sf.pal.admin.util.PagerUtil;
import jp.sf.pal.admin.web.deployer.DeployerEditPage;
import jp.sf.pal.admin.web.deployer.RemotePortletDeployConfirmPage;
import jp.sf.pal.admin.web.deployer.RemotePortletListPage;

import jp.sf.pal.jsf.custom.fileupload.UploadedFile;

public class PortletDeploymentService implements Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = 1801379304226762028L;

    private PortletDeploymentLogic portletDeploymentLogic;

    private PortletManagementLogic portletManagementLogic;
private RepositoryManagementLogic repositoryManagementLogic;
    private RemotePortletApplicationPager remotePortletApplicationPager;

    private PortletApplicationDxo portletApplicationDxo;

    /**
     * @return the portletDeploymentLogic
     */
    public PortletDeploymentLogic getPortletDeploymentLogic()
    {
        return portletDeploymentLogic;
    }

    /**
     * @param portletDeploymentLogic the portletDeploymentLogic to set
     */
    public void setPortletDeploymentLogic(
            PortletDeploymentLogic portletDeploymentLogic)
    {
        this.portletDeploymentLogic = portletDeploymentLogic;
    }

    /**
     * @return the portletManagementLogic
     */
    public PortletManagementLogic getPortletManagementLogic()
    {
        return portletManagementLogic;
    }

    /**
     * @param portletManagementLogic the portletManagementLogic to set
     */
    public void setPortletManagementLogic(
            PortletManagementLogic portletManagementLogic)
    {
        this.portletManagementLogic = portletManagementLogic;
    }

    /**
     * @return the repositoryManagementLogic
     */
    public RepositoryManagementLogic getRepositoryManagementLogic()
    {
        return repositoryManagementLogic;
    }

    /**
     * @param repositoryManagementLogic the repositoryManagementLogic to set
     */
    public void setRepositoryManagementLogic(
            RepositoryManagementLogic repositoryManagementLogic)
    {
        this.repositoryManagementLogic = repositoryManagementLogic;
    }

    /**
     * @return the remotePortletApplicationPager
     */
    public RemotePortletApplicationPager getRemotePortletApplicationPager()
    {
        return remotePortletApplicationPager;
    }

    /**
     * @param remotePortletApplicationPager the remotePortletApplicationPager to set
     */
    public void setRemotePortletApplicationPager(
            RemotePortletApplicationPager remotePortletApplicationPager)
    {
        this.remotePortletApplicationPager = remotePortletApplicationPager;
    }

    /**
     * @return the portletApplicationDxo
     */
    public PortletApplicationDxo getPortletApplicationDxo()
    {
        return portletApplicationDxo;
    }

    /**
     * @param portletApplicationDxo the portletApplicationDxo to set
     */
    public void setPortletApplicationDxo(
            PortletApplicationDxo portletApplicationDxo)
    {
        this.portletApplicationDxo = portletApplicationDxo;
    }

    public void deploy(DeployerEditPage page) throws PALAdminException
    {
        // store uploaded file
        File localFile = null;
        UploadedFile uploadedFile = page.getPortletApplicationFile();
        try
        {
            localFile = portletDeploymentLogic.storeLocalFile(uploadedFile
                    .getInputStream());
        }
        catch (IOException e)
        {
            throw new PALAdminException(
                    "Could not get the input stream for the uploaded file.", e);
        }

        String name = removeExtension(uploadedFile.getName());
        PortletApplication pa = new PortletApplication();
        pa.setName(name);
        pa.setArtifactId(name);
        pa.setBinaryUrl(PortletDeployer.FILEPATH_PROTOCOL_TEMP
                + localFile.getAbsolutePath());
        pa.setPackaging(getExtension(uploadedFile.getName()));

        portletDeploymentLogic.deploy(pa);

    }

    private String removeExtension(String name)
    {
        int pos = name.lastIndexOf(".");
        if (pos != -1)
        {
            return name.substring(0, pos);
        }
        return name;
    }

    private String getExtension(String name)
    {
        int pos = name.lastIndexOf(".");
        if (pos != -1 && pos <= name.length())
        {
            return name.substring(pos + 1);
        }
        return "";
    }

    public void loadPage(RemotePortletListPage page)
    {
        RemotePortletApplicationPager pager = getRemotePortletApplicationPager();

        // check page action
        PagerUtil.updatePageNumber(pager,
                PALAdminConstants.PREVIOUS_PAGE_NUMBER,
                PALAdminConstants.NEXT_PAGE_NUMBER);

        // set  list
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        portletApplicationDxo.convert(getPortletManagementLogic()
                .getPortletApplications(pager), list);
        PagerUtil.updatePagerPage(page, pager);
        page.setPortletApplicationItems(list);

        //set repository names
        ArrayList<Map<String, String>> repositoryItems = new ArrayList<Map<String, String>>();
        Iterator<Repository> items = repositoryManagementLogic.getRepositories()
                .iterator();
        while (items.hasNext())
        {
            String value = items.next().getName();
            repositoryItems.add(PALAdminUtil.createItem(value, value));
        }
        page.setRepositoryNameItems(repositoryItems);

    }

    public void updatePager(RemotePortletListPage page)
    {
        getRemotePortletApplicationPager().setRepositoryName(
                page.getRepositoryName());
    }

    public void deploy(RemotePortletDeployConfirmPage page)
            throws PALAdminException
    {
        PortletApplication pa = getPortletManagementLogic()
                .getPortletApplication(page.getGroupId(), page.getArtifactId(),
                        page.getVersion(), page.getPackaging());
        if (pa == null)
        {
            throw new PALAdminException("Could not find the portlet. page="
                    + page);
        }

        portletDeploymentLogic.deploy(pa);
    }
}
