/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.dxo.RoleDxo;
import jp.sf.pal.admin.entity.Role;
import jp.sf.pal.admin.logic.SecurityProviderLogic;
import jp.sf.pal.admin.pager.RolePager;
import jp.sf.pal.admin.util.PagerUtil;
import jp.sf.pal.admin.web.role.AbstractRolePage;
import jp.sf.pal.admin.web.role.RoleListPage;

public class RoleManagementService implements Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = -1554894839410568875L;

    private RolePager rolePager;

    private SecurityProviderLogic securityProviderLogic;

    private RoleDxo roleDxo;

    /**
     * @return the securityProviderLogic
     */
    public SecurityProviderLogic getSecurityProviderLogic()
    {
        return securityProviderLogic;
    }

    /**
     * @param securityProviderLogic the securityProviderLogic to set
     */
    public void setSecurityProviderLogic(
            SecurityProviderLogic securityProviderLogic)
    {
        this.securityProviderLogic = securityProviderLogic;
    }

    /**
     * @return the roleDxo
     */
    public RoleDxo getRoleDxo()
    {
        return roleDxo;
    }

    /**
     * @param roleDxo the roleDxo to set
     */
    public void setRoleDxo(RoleDxo roleDxo)
    {
        this.roleDxo = roleDxo;
    }

    /**
     * @return the roleListPager
     */
    public RolePager getRolePager()
    {
        return rolePager;
    }

    /**
     * @param roleListPager the roleListPager to set
     */
    public void setRolePager(RolePager roleListPager)
    {
        this.rolePager = roleListPager;
    }

    public void insert(AbstractRolePage page) throws PALAdminException
    {
        Role entity = new Role();
        roleDxo.convert(page, entity);
        securityProviderLogic.insertRole(entity);
    }

    public void delete(AbstractRolePage page) throws PALAdminException
    {
        Role entity = new Role();
        roleDxo.convert(page, entity);
        securityProviderLogic.deleteRole(entity);
    }

    public void loadPage(RoleListPage page)
    {
        RolePager pager = getRolePager();

        // check page action
        PagerUtil.updatePageNumber(pager,
                PALAdminConstants.PREVIOUS_PAGE_NUMBER,
                PALAdminConstants.NEXT_PAGE_NUMBER);

        // set role list
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        roleDxo.convert(securityProviderLogic.getRoles(pager), list);
        PagerUtil.updatePagerPage(page, pager);
        page.setRoleItems(list);

    }
}
