/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.util;

import java.util.Map;

import javax.faces.context.FacesContext;

import jp.sf.pal.admin.pager.Pager;
import jp.sf.pal.admin.web.PagerPage;

public class PagerUtil
{
    /**
     * @return the facesContext
     */
    private static FacesContext getFacesContext()
    {
        return FacesContext.getCurrentInstance();
    }

    public static void updatePageNumber(Pager pager, String prevKey,
            String nextKey)
    {
        Map requestMap = getFacesContext().getExternalContext()
                .getRequestParameterMap();

        String prev = (String) requestMap.get(prevKey);
        if (prev != null)
        {
            int pageNum = Integer.parseInt(prev);
            pager.setOffset((pageNum - 1) * pager.getLimit());
            return;
        }

        String next = (String) requestMap.get(nextKey);
        if (next != null)
        {
            int pageNum = Integer.parseInt(next);
            pager.setOffset((pageNum - 1) * pager.getLimit());
            return;
        }
    }

    public static void updatePagerPage(PagerPage page, Pager pager)
    {
        // update page
        page.setCount(pager.getCount());
        page.setMaxPageNumber((pager.getCount() - 1) / pager.getLimit() + 1);
        page.setCurrentPageNumber(pager.getOffset() / pager.getLimit() + 1);
        if (page.getMaxPageNumber() > page.getCurrentPageNumber())
        {
            page.setNextPageNumber(page.getCurrentPageNumber() + 1);
        }
        else
        {
            page.setNextPageNumber(null);
        }
        if (page.getCurrentPageNumber() > 1)
        {
            page.setPreviousPageNumber(page.getCurrentPageNumber() - 1);
        }
        else
        {
            page.setPreviousPageNumber(null);
        }
    }
}
