/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web;

public abstract class AbstractPagerPage extends AbstractCrudPage implements PagerPage
{

    private Integer count;

    private Integer currentPageNumber;

    private Integer maxPageNumber;

    private Integer previousPageNumber;

    private Integer nextPageNumber;

    public AbstractPagerPage()
    {
        super();
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.web.PagerPage#getCount()
     */
    public Integer getCount()
    {
        return count;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.web.PagerPage#setCount(java.lang.Integer)
     */
    public void setCount(Integer count)
    {
        this.count = count;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.web.PagerPage#getCurrentPageNumber()
     */
    public Integer getCurrentPageNumber()
    {
        return currentPageNumber;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.web.PagerPage#setCurrentPageNumber(java.lang.Integer)
     */
    public void setCurrentPageNumber(Integer currentPageNumber)
    {
        this.currentPageNumber = currentPageNumber;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.web.PagerPage#getMaxPageNumber()
     */
    public Integer getMaxPageNumber()
    {
        return maxPageNumber;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.web.PagerPage#setMaxPageNumber(java.lang.Integer)
     */
    public void setMaxPageNumber(Integer maxPageNumber)
    {
        this.maxPageNumber = maxPageNumber;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.web.PagerPage#getNextPageNumber()
     */
    public Integer getNextPageNumber()
    {
        return nextPageNumber;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.web.PagerPage#setNextPageNumber(java.lang.Integer)
     */
    public void setNextPageNumber(Integer nextPageNumber)
    {
        this.nextPageNumber = nextPageNumber;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.web.PagerPage#getPreviousPageNumber()
     */
    public Integer getPreviousPageNumber()
    {
        return previousPageNumber;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.admin.web.PagerPage#setPreviousPageNumber(java.lang.Integer)
     */
    public void setPreviousPageNumber(Integer previousPageNumber)
    {
        this.previousPageNumber = previousPageNumber;
    }

}