/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web;

public final class CrudType {

	public static final int CREATE = 0;
	
	public static final int READ = 1;
	
	public static final int UPDATE = 2;
	
	public static final int DELETE = 3;

	public static String toString(int type) {
		String result = "";
		switch(type) {
			case CREATE:
				result = "CREATE";
				break;
			case UPDATE:
				result = "UPDATE";
				break;
			case DELETE:
				result = "DELETE";
				break;
			default:
				break;
		}
		return result;
	}
}