/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.deployer;

import java.io.Serializable;

import javax.faces.internal.FacesMessageUtil;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.service.PortletDeploymentService;
import jp.sf.pal.admin.web.AbstractCrudPage;

import jp.sf.pal.jsf.custom.fileupload.UploadedFile;

public class DeployerEditPage extends AbstractCrudPage implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = -1591324603578689328L;

    //    @Required
    private UploadedFile portletApplicationFile;

    private PortletDeploymentService portletDeploymentService;

    public UploadedFile getPortletApplicationFile() {
        return portletApplicationFile;
    }

    public void setPortletApplicationFile(UploadedFile portletApplicationFile) {
        this.portletApplicationFile = portletApplicationFile;
    }

    /**
     * @return the portletDeploymentService
     */
    public PortletDeploymentService getPortletDeploymentService() {
        return portletDeploymentService;
    }

    /**
     * @param portletDeploymentService the portletDeploymentService to set
     */
    public void setPortletDeploymentService(
            PortletDeploymentService portletDeploymentService) {
        this.portletDeploymentService = portletDeploymentService;
    }

    public String initialize() {
        return null;
    }

    public String prerender() {
        return null;
    }

    public String doFinish() {
        if (portletApplicationFile != null) {
            try {
                portletDeploymentService.deploy(this);
                FacesMessageUtil
                        .addInfoMessage("started.portlet.application.deployment");
            } catch (PALAdminException e) {
                FacesMessageUtil
                        .addErrorMessage("failed.to.start.portlet.application.deployment");
            }
        } else {
            FacesMessageUtil.addErrorMessage("invalid.upload.file");
        }
        return null;
    }
}
