/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.deployer;

import javax.faces.internal.FacesMessageUtil;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.service.RepositoryManagementService;
import jp.sf.pal.admin.web.AbstractCrudPage;
import jp.sf.pal.admin.web.CrudType;

import org.seasar.teeda.extension.annotation.takeover.TakeOver;
import org.seasar.teeda.extension.annotation.takeover.TakeOverType;

public class RemoteRepositoryConfirmPage extends AbstractCrudPage
{

    private String name;

    private String configPath;

    private RepositoryManagementService repositoryManagementService;

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return the configPath
     */
    public String getConfigPath()
    {
        return configPath;
    }

    /**
     * @param configPath the configPath to set
     */
    public void setConfigPath(String configPath)
    {
        this.configPath = configPath;
    }

    /**
     * @return the repositoryManagementService
     */
    public RepositoryManagementService getRepositoryManagementService()
    {
        return repositoryManagementService;
    }

    /**
     * @param repositoryManagementService the repositoryManagementService to set
     */
    public void setRepositoryManagementService(
            RepositoryManagementService repositoryManagementService)
    {
        this.repositoryManagementService = repositoryManagementService;
    }

    public String initialize()
    {
        return null;
    }

    public Class prerender()
    {
        return null;
    }

    @TakeOver(type = TakeOverType.NEVER)
    public Class doFinish()
    {
        if (getName() == null)
        {
            FacesMessageUtil.addWarnMessage("invalid.repository.parameters");
            return RemoteRepositoryListPage.class;
        }

        switch (getCrudType())
        {
            case CrudType.CREATE:
                try
                {
                    getRepositoryManagementService().create(this);
                    FacesMessageUtil.addInfoMessage("added.new.repository");
                }
                catch (PALAdminException e)
                {
                    FacesMessageUtil
                            .addErrorMessage("failed.to.add.new.repository");
                }
                break;
            case CrudType.UPDATE:
                try
                {
                    getRepositoryManagementService().update(this);
                    FacesMessageUtil.addInfoMessage("updated.repository");
                }
                catch (PALAdminException e)
                {
                    FacesMessageUtil
                            .addErrorMessage("failed.to.update.repository");
                }
                break;
            case CrudType.DELETE:
                try
                {
                    getRepositoryManagementService().delete(this);
                    FacesMessageUtil.addInfoMessage("deleted.repository");
                }
                catch (PALAdminException e)
                {
                    FacesMessageUtil
                            .addErrorMessage("failed.to.delete.repository");
                }
                break;
            default:
                break;
        }
        return RemoteRepositoryListPage.class;
    }

    public boolean isComeFromList()
    {
        return getCrudType() == CrudType.READ
                || getCrudType() == CrudType.DELETE;
    }

}
