/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.group;

import java.io.Serializable;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.web.CrudType;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;

public class GroupConfirmPage extends AbstractGroupPage implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = -283173697251156241L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(GroupConfirmPage.class);

    public String initialize() {
        return null;
    }

    public String prerender() {
        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    public Class doFinish() {
        switch (getCrudType()) {
        case CrudType.CREATE:
            try {
                getGroupManagementService().insert(this);
                FacesMessageUtil.addInfoMessage("added.new.group",
                        new Object[] { getName() });
            } catch (PALAdminException e) {
                FacesMessageUtil.addErrorMessage("failed.to.add.new.group",
                        new Object[] { getName() });
                logger.error("Failed to add a new group: " + getName(), e);
            }
            break;
        //            case CrudType.UPDATE:
        //                break;
        case CrudType.DELETE:
            try {
                getGroupManagementService().delete(this);
                FacesMessageUtil.addInfoMessage("deleted.group",
                        new Object[] { getName() });
            } catch (PALAdminException e) {
                FacesMessageUtil.addErrorMessage("failed.to.delete.group",
                        new Object[] { getName() });
                logger.error("Failed to delete a new group: " + getName(), e);
            }
            break;
        default:
            break;
        }
        return GroupListPage.class;
    }

    public boolean isComeFromList() {
        return getCrudType() == CrudType.READ
                || getCrudType() == CrudType.DELETE;

    }

}
