/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.registration;

import java.io.Serializable;

import javax.faces.context.FacesContext;

import jp.sf.pal.admin.service.UserRegistrationService;

import org.seasar.teeda.extension.annotation.validator.Length;
import org.seasar.teeda.extension.annotation.validator.Required;
import org.seasar.teeda.extension.util.LabelHelper;

public abstract class AbstractUserRegistrationPage implements Serializable {

    private FacesContext facesContext;

    private LabelHelper labelHelper;

    private UserRegistrationService userRegistrationService;

    @Length(maximum = 80)
    private String password;

    @Length(maximum = 25)
    private String userBdate;

    @Required
    @Length(maximum = 80)
    private String userBusinessInfoOnlineEmail;

    @Length(maximum = 80)
    private String userBusinessInfoOnlineUri;

    @Length(maximum = 80)
    private String userBusinessInfoPostalCity;

    @Length(maximum = 80)
    private String userBusinessInfoPostalCountry;

    @Length(maximum = 80)
    private String userBusinessInfoPostalName;

    @Length(maximum = 80)
    private String userBusinessInfoPostalOrganization;

    @Length(maximum = 80)
    private String userBusinessInfoPostalPostalcode;

    @Length(maximum = 80)
    private String userBusinessInfoPostalStateprov;

    @Length(maximum = 80)
    private String userBusinessInfoPostalStreet;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomFaxComment;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomFaxExt;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomFaxIntcode;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomFaxLoccode;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomFaxNumber;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomMobileComment;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomMobileExt;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomMobileIntcode;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomMobileLoccode;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomMobileNumber;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomPagerComment;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomPagerExt;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomPagerIntcode;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomPagerLoccode;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomPagerNumber;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomTelephoneComment;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomTelephoneExt;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomTelephoneIntcode;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomTelephoneLoccode;

    @Length(maximum = 80)
    private String userBusinessInfoTelecomTelephoneNumber;

    @Length(maximum = 80)
    private String userDepartment;

    @Length(maximum = 80)
    private String userEmployer;

    @Length(maximum = 10)
    private String userGender;

    @Length(maximum = 80)
    private String userHomeInfoOnlineEmail;

    @Length(maximum = 80)
    private String userHomeInfoOnlineUri;

    @Length(maximum = 80)
    private String userHomeInfoPostalCity;

    @Length(maximum = 80)
    private String userHomeInfoPostalCountry;

    @Length(maximum = 80)
    private String userHomeInfoPostalName;

    @Length(maximum = 80)
    private String userHomeInfoPostalOrganization;

    @Length(maximum = 80)
    private String userHomeInfoPostalPostalcode;

    @Length(maximum = 80)
    private String userHomeInfoPostalStateprov;

    @Length(maximum = 80)
    private String userHomeInfoPostalStreet;

    @Length(maximum = 80)
    private String userHomeInfoTelecomFaxComment;

    @Length(maximum = 80)
    private String userHomeInfoTelecomFaxExt;

    @Length(maximum = 80)
    private String userHomeInfoTelecomFaxIntcode;

    @Length(maximum = 80)
    private String userHomeInfoTelecomFaxLoccode;

    @Length(maximum = 80)
    private String userHomeInfoTelecomFaxNumber;

    @Length(maximum = 80)
    private String userHomeInfoTelecomMobileComment;

    @Length(maximum = 80)
    private String userHomeInfoTelecomMobileExt;

    @Length(maximum = 80)
    private String userHomeInfoTelecomMobileIntcode;

    @Length(maximum = 80)
    private String userHomeInfoTelecomMobileLoccode;

    @Length(maximum = 80)
    private String userHomeInfoTelecomMobileNumber;

    @Length(maximum = 80)
    private String userHomeInfoTelecomPagerComment;

    @Length(maximum = 80)
    private String userHomeInfoTelecomPagerExt;

    @Length(maximum = 80)
    private String userHomeInfoTelecomPagerIntcode;

    @Length(maximum = 80)
    private String userHomeInfoTelecomPagerLoccode;

    @Length(maximum = 80)
    private String userHomeInfoTelecomPagerNumber;

    @Length(maximum = 80)
    private String userHomeInfoTelecomTelephoneComment;

    @Length(maximum = 80)
    private String userHomeInfoTelecomTelephoneExt;

    @Length(maximum = 80)
    private String userHomeInfoTelecomTelephoneIntcode;

    @Length(maximum = 80)
    private String userHomeInfoTelecomTelephoneLoccode;

    @Length(maximum = 80)
    private String userHomeInfoTelecomTelephoneNumber;

    @Length(maximum = 80)
    private String userJobtitle;

    @Required
    @Length(maximum = 80)
    private String userName;

    @Length(maximum = 30)
    private String userNameFamily;

    @Length(maximum = 30)
    private String userNameGiven;

    @Length(maximum = 30)
    private String userNameMiddle;

    @Length(maximum = 30)
    private String userNameNickName;

    @Length(maximum = 10)
    private String userNamePrefix;

    @Length(maximum = 10)
    private String userNameSuffix;

    @Length(maximum = 80)
    private String verifyPassword;

    /**
     * @return the facesContext
     */
    public FacesContext getFacesContext() {
        return facesContext;
    }

    /**
     * @param facesContext the facesContext to set
     */
    public void setFacesContext(FacesContext facesContext) {
        this.facesContext = facesContext;
    }

    /**
     * @return the userRegistrationService
     */
    public UserRegistrationService getUserRegistrationService() {
        return userRegistrationService;
    }

    /**
     * @param userRegistrationService the userRegistrationService to set
     */
    public void setUserRegistrationService(
            UserRegistrationService userRegistrationService) {
        this.userRegistrationService = userRegistrationService;
    }

    /**
     * @return the labelHelper
     */
    public LabelHelper getLabelHelper() {
        return labelHelper;
    }

    /**
     * @param labelHelper the labelHelper to set
     */
    public void setLabelHelper(LabelHelper labelHelper) {
        this.labelHelper = labelHelper;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserBdate() {
        return userBdate;
    }

    public void setUserBdate(String userBdate) {
        this.userBdate = userBdate;
    }

    public String getUserBusinessInfoOnlineEmail() {
        return userBusinessInfoOnlineEmail;
    }

    public void setUserBusinessInfoOnlineEmail(
            String userBusinessInfoOnlineEmail) {
        this.userBusinessInfoOnlineEmail = userBusinessInfoOnlineEmail;
    }

    public String getUserBusinessInfoOnlineUri() {
        return userBusinessInfoOnlineUri;
    }

    public void setUserBusinessInfoOnlineUri(String userBusinessInfoOnlineUri) {
        this.userBusinessInfoOnlineUri = userBusinessInfoOnlineUri;
    }

    public String getUserBusinessInfoPostalCity() {
        return userBusinessInfoPostalCity;
    }

    public void setUserBusinessInfoPostalCity(String userBusinessInfoPostalCity) {
        this.userBusinessInfoPostalCity = userBusinessInfoPostalCity;
    }

    public String getUserBusinessInfoPostalCountry() {
        return userBusinessInfoPostalCountry;
    }

    public void setUserBusinessInfoPostalCountry(
            String userBusinessInfoPostalCountry) {
        this.userBusinessInfoPostalCountry = userBusinessInfoPostalCountry;
    }

    public String getUserBusinessInfoPostalName() {
        return userBusinessInfoPostalName;
    }

    public void setUserBusinessInfoPostalName(String userBusinessInfoPostalName) {
        this.userBusinessInfoPostalName = userBusinessInfoPostalName;
    }

    public String getUserBusinessInfoPostalOrganization() {
        return userBusinessInfoPostalOrganization;
    }

    public void setUserBusinessInfoPostalOrganization(
            String userBusinessInfoPostalOrganization) {
        this.userBusinessInfoPostalOrganization = userBusinessInfoPostalOrganization;
    }

    public String getUserBusinessInfoPostalPostalcode() {
        return userBusinessInfoPostalPostalcode;
    }

    public void setUserBusinessInfoPostalPostalcode(
            String userBusinessInfoPostalPostalcode) {
        this.userBusinessInfoPostalPostalcode = userBusinessInfoPostalPostalcode;
    }

    public String getUserBusinessInfoPostalStateprov() {
        return userBusinessInfoPostalStateprov;
    }

    public void setUserBusinessInfoPostalStateprov(
            String userBusinessInfoPostalStateprov) {
        this.userBusinessInfoPostalStateprov = userBusinessInfoPostalStateprov;
    }

    public String getUserBusinessInfoPostalStreet() {
        return userBusinessInfoPostalStreet;
    }

    public void setUserBusinessInfoPostalStreet(
            String userBusinessInfoPostalStreet) {
        this.userBusinessInfoPostalStreet = userBusinessInfoPostalStreet;
    }

    public String getUserBusinessInfoTelecomFaxComment() {
        return userBusinessInfoTelecomFaxComment;
    }

    public void setUserBusinessInfoTelecomFaxComment(
            String userBusinessInfoTelecomFaxComment) {
        this.userBusinessInfoTelecomFaxComment = userBusinessInfoTelecomFaxComment;
    }

    public String getUserBusinessInfoTelecomFaxExt() {
        return userBusinessInfoTelecomFaxExt;
    }

    public void setUserBusinessInfoTelecomFaxExt(
            String userBusinessInfoTelecomFaxExt) {
        this.userBusinessInfoTelecomFaxExt = userBusinessInfoTelecomFaxExt;
    }

    public String getUserBusinessInfoTelecomFaxIntcode() {
        return userBusinessInfoTelecomFaxIntcode;
    }

    public void setUserBusinessInfoTelecomFaxIntcode(
            String userBusinessInfoTelecomFaxIntcode) {
        this.userBusinessInfoTelecomFaxIntcode = userBusinessInfoTelecomFaxIntcode;
    }

    public String getUserBusinessInfoTelecomFaxLoccode() {
        return userBusinessInfoTelecomFaxLoccode;
    }

    public void setUserBusinessInfoTelecomFaxLoccode(
            String userBusinessInfoTelecomFaxLoccode) {
        this.userBusinessInfoTelecomFaxLoccode = userBusinessInfoTelecomFaxLoccode;
    }

    public String getUserBusinessInfoTelecomFaxNumber() {
        return userBusinessInfoTelecomFaxNumber;
    }

    public void setUserBusinessInfoTelecomFaxNumber(
            String userBusinessInfoTelecomFaxNumber) {
        this.userBusinessInfoTelecomFaxNumber = userBusinessInfoTelecomFaxNumber;
    }

    public String getUserBusinessInfoTelecomMobileComment() {
        return userBusinessInfoTelecomMobileComment;
    }

    public void setUserBusinessInfoTelecomMobileComment(
            String userBusinessInfoTelecomMobileComment) {
        this.userBusinessInfoTelecomMobileComment = userBusinessInfoTelecomMobileComment;
    }

    public String getUserBusinessInfoTelecomMobileExt() {
        return userBusinessInfoTelecomMobileExt;
    }

    public void setUserBusinessInfoTelecomMobileExt(
            String userBusinessInfoTelecomMobileExt) {
        this.userBusinessInfoTelecomMobileExt = userBusinessInfoTelecomMobileExt;
    }

    public String getUserBusinessInfoTelecomMobileIntcode() {
        return userBusinessInfoTelecomMobileIntcode;
    }

    public void setUserBusinessInfoTelecomMobileIntcode(
            String userBusinessInfoTelecomMobileIntcode) {
        this.userBusinessInfoTelecomMobileIntcode = userBusinessInfoTelecomMobileIntcode;
    }

    public String getUserBusinessInfoTelecomMobileLoccode() {
        return userBusinessInfoTelecomMobileLoccode;
    }

    public void setUserBusinessInfoTelecomMobileLoccode(
            String userBusinessInfoTelecomMobileLoccode) {
        this.userBusinessInfoTelecomMobileLoccode = userBusinessInfoTelecomMobileLoccode;
    }

    public String getUserBusinessInfoTelecomMobileNumber() {
        return userBusinessInfoTelecomMobileNumber;
    }

    public void setUserBusinessInfoTelecomMobileNumber(
            String userBusinessInfoTelecomMobileNumber) {
        this.userBusinessInfoTelecomMobileNumber = userBusinessInfoTelecomMobileNumber;
    }

    public String getUserBusinessInfoTelecomPagerComment() {
        return userBusinessInfoTelecomPagerComment;
    }

    public void setUserBusinessInfoTelecomPagerComment(
            String userBusinessInfoTelecomPagerComment) {
        this.userBusinessInfoTelecomPagerComment = userBusinessInfoTelecomPagerComment;
    }

    public String getUserBusinessInfoTelecomPagerExt() {
        return userBusinessInfoTelecomPagerExt;
    }

    public void setUserBusinessInfoTelecomPagerExt(
            String userBusinessInfoTelecomPagerExt) {
        this.userBusinessInfoTelecomPagerExt = userBusinessInfoTelecomPagerExt;
    }

    public String getUserBusinessInfoTelecomPagerIntcode() {
        return userBusinessInfoTelecomPagerIntcode;
    }

    public void setUserBusinessInfoTelecomPagerIntcode(
            String userBusinessInfoTelecomPagerIntcode) {
        this.userBusinessInfoTelecomPagerIntcode = userBusinessInfoTelecomPagerIntcode;
    }

    public String getUserBusinessInfoTelecomPagerLoccode() {
        return userBusinessInfoTelecomPagerLoccode;
    }

    public void setUserBusinessInfoTelecomPagerLoccode(
            String userBusinessInfoTelecomPagerLoccode) {
        this.userBusinessInfoTelecomPagerLoccode = userBusinessInfoTelecomPagerLoccode;
    }

    public String getUserBusinessInfoTelecomPagerNumber() {
        return userBusinessInfoTelecomPagerNumber;
    }

    public void setUserBusinessInfoTelecomPagerNumber(
            String userBusinessInfoTelecomPagerNumber) {
        this.userBusinessInfoTelecomPagerNumber = userBusinessInfoTelecomPagerNumber;
    }

    public String getUserBusinessInfoTelecomTelephoneComment() {
        return userBusinessInfoTelecomTelephoneComment;
    }

    public void setUserBusinessInfoTelecomTelephoneComment(
            String userBusinessInfoTelecomTelephoneComment) {
        this.userBusinessInfoTelecomTelephoneComment = userBusinessInfoTelecomTelephoneComment;
    }

    public String getUserBusinessInfoTelecomTelephoneExt() {
        return userBusinessInfoTelecomTelephoneExt;
    }

    public void setUserBusinessInfoTelecomTelephoneExt(
            String userBusinessInfoTelecomTelephoneExt) {
        this.userBusinessInfoTelecomTelephoneExt = userBusinessInfoTelecomTelephoneExt;
    }

    public String getUserBusinessInfoTelecomTelephoneIntcode() {
        return userBusinessInfoTelecomTelephoneIntcode;
    }

    public void setUserBusinessInfoTelecomTelephoneIntcode(
            String userBusinessInfoTelecomTelephoneIntcode) {
        this.userBusinessInfoTelecomTelephoneIntcode = userBusinessInfoTelecomTelephoneIntcode;
    }

    public String getUserBusinessInfoTelecomTelephoneLoccode() {
        return userBusinessInfoTelecomTelephoneLoccode;
    }

    public void setUserBusinessInfoTelecomTelephoneLoccode(
            String userBusinessInfoTelecomTelephoneLoccode) {
        this.userBusinessInfoTelecomTelephoneLoccode = userBusinessInfoTelecomTelephoneLoccode;
    }

    public String getUserBusinessInfoTelecomTelephoneNumber() {
        return userBusinessInfoTelecomTelephoneNumber;
    }

    public void setUserBusinessInfoTelecomTelephoneNumber(
            String userBusinessInfoTelecomTelephoneNumber) {
        this.userBusinessInfoTelecomTelephoneNumber = userBusinessInfoTelecomTelephoneNumber;
    }

    public String getUserDepartment() {
        return userDepartment;
    }

    public void setUserDepartment(String userDepartment) {
        this.userDepartment = userDepartment;
    }

    public String getUserEmployer() {
        return userEmployer;
    }

    public void setUserEmployer(String userEmployer) {
        this.userEmployer = userEmployer;
    }

    public String getUserGender() {
        return userGender;
    }

    public void setUserGender(String userGender) {
        this.userGender = userGender;
    }

    public String getUserHomeInfoOnlineEmail() {
        return userHomeInfoOnlineEmail;
    }

    public void setUserHomeInfoOnlineEmail(String userHomeInfoOnlineEmail) {
        this.userHomeInfoOnlineEmail = userHomeInfoOnlineEmail;
    }

    public String getUserHomeInfoOnlineUri() {
        return userHomeInfoOnlineUri;
    }

    public void setUserHomeInfoOnlineUri(String userHomeInfoOnlineUri) {
        this.userHomeInfoOnlineUri = userHomeInfoOnlineUri;
    }

    public String getUserHomeInfoPostalCity() {
        return userHomeInfoPostalCity;
    }

    public void setUserHomeInfoPostalCity(String userHomeInfoPostalCity) {
        this.userHomeInfoPostalCity = userHomeInfoPostalCity;
    }

    public String getUserHomeInfoPostalCountry() {
        return userHomeInfoPostalCountry;
    }

    public void setUserHomeInfoPostalCountry(String userHomeInfoPostalCountry) {
        this.userHomeInfoPostalCountry = userHomeInfoPostalCountry;
    }

    public String getUserHomeInfoPostalName() {
        return userHomeInfoPostalName;
    }

    public void setUserHomeInfoPostalName(String userHomeInfoPostalName) {
        this.userHomeInfoPostalName = userHomeInfoPostalName;
    }

    public String getUserHomeInfoPostalOrganization() {
        return userHomeInfoPostalOrganization;
    }

    public void setUserHomeInfoPostalOrganization(
            String userHomeInfoPostalOrganization) {
        this.userHomeInfoPostalOrganization = userHomeInfoPostalOrganization;
    }

    public String getUserHomeInfoPostalPostalcode() {
        return userHomeInfoPostalPostalcode;
    }

    public void setUserHomeInfoPostalPostalcode(
            String userHomeInfoPostalPostalcode) {
        this.userHomeInfoPostalPostalcode = userHomeInfoPostalPostalcode;
    }

    public String getUserHomeInfoPostalStateprov() {
        return userHomeInfoPostalStateprov;
    }

    public void setUserHomeInfoPostalStateprov(
            String userHomeInfoPostalStateprov) {
        this.userHomeInfoPostalStateprov = userHomeInfoPostalStateprov;
    }

    public String getUserHomeInfoPostalStreet() {
        return userHomeInfoPostalStreet;
    }

    public void setUserHomeInfoPostalStreet(String userHomeInfoPostalStreet) {
        this.userHomeInfoPostalStreet = userHomeInfoPostalStreet;
    }

    public String getUserHomeInfoTelecomFaxComment() {
        return userHomeInfoTelecomFaxComment;
    }

    public void setUserHomeInfoTelecomFaxComment(
            String userHomeInfoTelecomFaxComment) {
        this.userHomeInfoTelecomFaxComment = userHomeInfoTelecomFaxComment;
    }

    public String getUserHomeInfoTelecomFaxExt() {
        return userHomeInfoTelecomFaxExt;
    }

    public void setUserHomeInfoTelecomFaxExt(String userHomeInfoTelecomFaxExt) {
        this.userHomeInfoTelecomFaxExt = userHomeInfoTelecomFaxExt;
    }

    public String getUserHomeInfoTelecomFaxIntcode() {
        return userHomeInfoTelecomFaxIntcode;
    }

    public void setUserHomeInfoTelecomFaxIntcode(
            String userHomeInfoTelecomFaxIntcode) {
        this.userHomeInfoTelecomFaxIntcode = userHomeInfoTelecomFaxIntcode;
    }

    public String getUserHomeInfoTelecomFaxLoccode() {
        return userHomeInfoTelecomFaxLoccode;
    }

    public void setUserHomeInfoTelecomFaxLoccode(
            String userHomeInfoTelecomFaxLoccode) {
        this.userHomeInfoTelecomFaxLoccode = userHomeInfoTelecomFaxLoccode;
    }

    public String getUserHomeInfoTelecomFaxNumber() {
        return userHomeInfoTelecomFaxNumber;
    }

    public void setUserHomeInfoTelecomFaxNumber(
            String userHomeInfoTelecomFaxNumber) {
        this.userHomeInfoTelecomFaxNumber = userHomeInfoTelecomFaxNumber;
    }

    public String getUserHomeInfoTelecomMobileComment() {
        return userHomeInfoTelecomMobileComment;
    }

    public void setUserHomeInfoTelecomMobileComment(
            String userHomeInfoTelecomMobileComment) {
        this.userHomeInfoTelecomMobileComment = userHomeInfoTelecomMobileComment;
    }

    public String getUserHomeInfoTelecomMobileExt() {
        return userHomeInfoTelecomMobileExt;
    }

    public void setUserHomeInfoTelecomMobileExt(
            String userHomeInfoTelecomMobileExt) {
        this.userHomeInfoTelecomMobileExt = userHomeInfoTelecomMobileExt;
    }

    public String getUserHomeInfoTelecomMobileIntcode() {
        return userHomeInfoTelecomMobileIntcode;
    }

    public void setUserHomeInfoTelecomMobileIntcode(
            String userHomeInfoTelecomMobileIntcode) {
        this.userHomeInfoTelecomMobileIntcode = userHomeInfoTelecomMobileIntcode;
    }

    public String getUserHomeInfoTelecomMobileLoccode() {
        return userHomeInfoTelecomMobileLoccode;
    }

    public void setUserHomeInfoTelecomMobileLoccode(
            String userHomeInfoTelecomMobileLoccode) {
        this.userHomeInfoTelecomMobileLoccode = userHomeInfoTelecomMobileLoccode;
    }

    public String getUserHomeInfoTelecomMobileNumber() {
        return userHomeInfoTelecomMobileNumber;
    }

    public void setUserHomeInfoTelecomMobileNumber(
            String userHomeInfoTelecomMobileNumber) {
        this.userHomeInfoTelecomMobileNumber = userHomeInfoTelecomMobileNumber;
    }

    public String getUserHomeInfoTelecomPagerComment() {
        return userHomeInfoTelecomPagerComment;
    }

    public void setUserHomeInfoTelecomPagerComment(
            String userHomeInfoTelecomPagerComment) {
        this.userHomeInfoTelecomPagerComment = userHomeInfoTelecomPagerComment;
    }

    public String getUserHomeInfoTelecomPagerExt() {
        return userHomeInfoTelecomPagerExt;
    }

    public void setUserHomeInfoTelecomPagerExt(
            String userHomeInfoTelecomPagerExt) {
        this.userHomeInfoTelecomPagerExt = userHomeInfoTelecomPagerExt;
    }

    public String getUserHomeInfoTelecomPagerIntcode() {
        return userHomeInfoTelecomPagerIntcode;
    }

    public void setUserHomeInfoTelecomPagerIntcode(
            String userHomeInfoTelecomPagerIntcode) {
        this.userHomeInfoTelecomPagerIntcode = userHomeInfoTelecomPagerIntcode;
    }

    public String getUserHomeInfoTelecomPagerLoccode() {
        return userHomeInfoTelecomPagerLoccode;
    }

    public void setUserHomeInfoTelecomPagerLoccode(
            String userHomeInfoTelecomPagerLoccode) {
        this.userHomeInfoTelecomPagerLoccode = userHomeInfoTelecomPagerLoccode;
    }

    public String getUserHomeInfoTelecomPagerNumber() {
        return userHomeInfoTelecomPagerNumber;
    }

    public void setUserHomeInfoTelecomPagerNumber(
            String userHomeInfoTelecomPagerNumber) {
        this.userHomeInfoTelecomPagerNumber = userHomeInfoTelecomPagerNumber;
    }

    public String getUserHomeInfoTelecomTelephoneComment() {
        return userHomeInfoTelecomTelephoneComment;
    }

    public void setUserHomeInfoTelecomTelephoneComment(
            String userHomeInfoTelecomTelephoneComment) {
        this.userHomeInfoTelecomTelephoneComment = userHomeInfoTelecomTelephoneComment;
    }

    public String getUserHomeInfoTelecomTelephoneExt() {
        return userHomeInfoTelecomTelephoneExt;
    }

    public void setUserHomeInfoTelecomTelephoneExt(
            String userHomeInfoTelecomTelephoneExt) {
        this.userHomeInfoTelecomTelephoneExt = userHomeInfoTelecomTelephoneExt;
    }

    public String getUserHomeInfoTelecomTelephoneIntcode() {
        return userHomeInfoTelecomTelephoneIntcode;
    }

    public void setUserHomeInfoTelecomTelephoneIntcode(
            String userHomeInfoTelecomTelephoneIntcode) {
        this.userHomeInfoTelecomTelephoneIntcode = userHomeInfoTelecomTelephoneIntcode;
    }

    public String getUserHomeInfoTelecomTelephoneLoccode() {
        return userHomeInfoTelecomTelephoneLoccode;
    }

    public void setUserHomeInfoTelecomTelephoneLoccode(
            String userHomeInfoTelecomTelephoneLoccode) {
        this.userHomeInfoTelecomTelephoneLoccode = userHomeInfoTelecomTelephoneLoccode;
    }

    public String getUserHomeInfoTelecomTelephoneNumber() {
        return userHomeInfoTelecomTelephoneNumber;
    }

    public void setUserHomeInfoTelecomTelephoneNumber(
            String userHomeInfoTelecomTelephoneNumber) {
        this.userHomeInfoTelecomTelephoneNumber = userHomeInfoTelecomTelephoneNumber;
    }

    public String getUserJobtitle() {
        return userJobtitle;
    }

    public void setUserJobtitle(String userJobtitle) {
        this.userJobtitle = userJobtitle;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserNameFamily() {
        return userNameFamily;
    }

    public void setUserNameFamily(String userNameFamily) {
        this.userNameFamily = userNameFamily;
    }

    public String getUserNameGiven() {
        return userNameGiven;
    }

    public void setUserNameGiven(String userNameGiven) {
        this.userNameGiven = userNameGiven;
    }

    public String getUserNameMiddle() {
        return userNameMiddle;
    }

    public void setUserNameMiddle(String userNameMiddle) {
        this.userNameMiddle = userNameMiddle;
    }

    public String getUserNameNickName() {
        return userNameNickName;
    }

    public void setUserNameNickName(String userNameNickName) {
        this.userNameNickName = userNameNickName;
    }

    public String getUserNamePrefix() {
        return userNamePrefix;
    }

    public void setUserNamePrefix(String userNamePrefix) {
        this.userNamePrefix = userNamePrefix;
    }

    public String getUserNameSuffix() {
        return userNameSuffix;
    }

    public void setUserNameSuffix(String userNameSuffix) {
        this.userNameSuffix = userNameSuffix;
    }

    public String getVerifyPassword() {
        return verifyPassword;
    }

    public void setVerifyPassword(String verifyPassword) {
        this.verifyPassword = verifyPassword;
    }

}
