package jp.sf.pal.admin.web.registration;

import java.io.Serializable;

import javax.faces.context.FacesContext;

import org.seasar.framework.log.Logger;

import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

public class ForgottenPasswordPage extends AbstractForgottenPasswordPage
        implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = -1002535740755952748L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(ForgottenPasswordPage.class);

    // TODO validation

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        //TODO Teeda problem: ExternalContext is released after calling action..
        setGuid((String) FacesContext.getCurrentInstance().getExternalContext()
                .getRequestParameterMap().get("guid"));
        if (getGuid() != null) {
            return ResetPasswordPage.class;
        }

        // render FacesMessage
        FacesMessageUtil.renderMessages();
        return null;
    }

    public Class<?> doFinish() {
        try {
            getUserRegistrationService().sendNewPassword(this);
            FacesMessageUtil.addInfoMessage("an_email_has_been_sent");
            return ForgottenPasswordPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);

        }

        return null;
    }

    public String getDoFinishValue() {
        return getLabelHelper().getLabelValue("RequestNewPassword");
    }

}
