/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.user;

import java.io.Serializable;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.util.PALAdminUtil;
import jp.sf.pal.admin.web.CrudType;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;
import org.seasar.teeda.extension.annotation.takeover.TakeOverType;

public class UserConfirmPage extends AbstractUserPage implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 5950243264539560661L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(UserConfirmPage.class);

    public String initialize() {
        return null;
    }

    public String prerender() {
        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    @TakeOver(type = TakeOverType.NEVER)
    public Class doFinish() {
        switch (getCrudType()) {
        case CrudType.CREATE:
            addUser();
            break;
        //            case CrudType.UPDATE:
        //                break;
        case CrudType.DELETE:
            deleteUser();
            break;
        default:
            break;
        }
        return UserListPage.class;
    }

    protected void addUser() {
        try {
            setPassword(PALAdminUtil.getPasswordFromSession());
            PALAdminUtil.removePasswordFromSession();
            getUserManagementService().insert(this);
            FacesMessageUtil.addInfoMessage("added.new.user",
                    new Object[] { getName() });
        } catch (PALAdminException e) {
            FacesMessageUtil.addErrorMessage("failed.to.add.new.user",
                    new Object[] { getName() });
            logger.error("Failed to add a new user: " + getName(), e);
        }
    }

    protected void deleteUser() {
        try {
            getUserManagementService().delete(this);
            FacesMessageUtil.addInfoMessage("deleted.user",
                    new Object[] { getName() });
        } catch (PALAdminException e) {
            FacesMessageUtil.addErrorMessage("failed.to.delete.user",
                    new Object[] { getName() });
            logger.error("Failed to delete the user: " + getName(), e);
        }
    }

    @TakeOver(properties = "name,updateRequired,roleName")
    public Class doCreate() {
        PALAdminUtil.removePasswordFromSession();
        return UserCreatePage.class;
    }

    public boolean isComeFromList() {
        return getCrudType() == CrudType.READ
                || getCrudType() == CrudType.DELETE;

    }

}
