package jp.sf.pal.ggadget.service;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import jp.sf.pal.ggadget.GGadgetException;
import jp.sf.pal.ggadget.entity.GGadget;
import jp.sf.pal.ggadget.pager.GGadgetPager;
import jp.sf.pal.ggadget.util.GGadgetHandler;
import jp.sf.pal.ggadget.util.GGadgetList;

import org.xml.sax.InputSource;

public class GGadgetService implements Serializable {

    private static final long serialVersionUID = 6932901501995247897L;

    public GGadgetList<GGadget> getGGadgetList(GGadgetPager pager)
            throws GGadgetException {
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser parser = spfactory.newSAXParser();
            GGadgetHandler gGadgetHandler = new GGadgetHandler(pager);
            Object content = new URL(pager.buildUrl()).getContent();
            if (content instanceof InputStream) {
                parser.parse(new InputSource(new InputStreamReader(
                        (InputStream) content, "UTF-8")), gGadgetHandler);
                return gGadgetHandler.getGGadgetList();
            }
            throw new GGadgetException("Invalid content: " + content);
        } catch (Exception e) {
            throw new GGadgetException(e);
        }

    }
}
