package jp.sf.pal.nvwidget.action;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.sf.pal.nvwidget.NvWidgetConstants;
import jp.sf.pal.nvwidget.NvWidgetException;
import jp.sf.pal.nvwidget.entity.NvWidget;
import jp.sf.pal.nvwidget.form.EditForm;
import jp.sf.pal.nvwidget.pager.NvWidgetPager;
import jp.sf.pal.nvwidget.service.NvWidgetService;
import jp.sf.pal.nvwidget.util.NvWidgetList;
import jp.sf.pal.nvwidget.util.NvWidgetUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.exception.ActionMessagesException;

public class EditAction {
    private static final Log log = LogFactory.getLog(EditAction.class);

    public List<NvWidget> widgetItems;

    public List<Integer> pageItems;

    public String currentName;

    public boolean existPrevPage;

    public boolean existNextPage;

    public int allRecordCount;

    public int allPageCount;

    public int currentPageNumber;

    @ActionForm
    private EditForm editForm;

    private NvWidgetPager nvWidgetPager;

    private NvWidgetService nvWidgetService;

    private transient HttpServletRequest request;

    @Execute(validator = false, input = "error.jsp")
    public String index() {
        try {
            currentName = NvWidgetUtil.getPreferenceValue(request,
                    NvWidgetConstants.NAME, "");

            editForm.height = NvWidgetUtil.getPreferenceValue(request,
                    NvWidgetConstants.HEIGHT, "250");

            editForm.category = nvWidgetPager.getCategory();
            editForm.query = nvWidgetPager.getQuery();
            editForm.region = nvWidgetPager.getRegion();

            NvWidgetList<NvWidget> widgets = nvWidgetService
                    .getNvWidgetList(nvWidgetPager);
            allRecordCount = widgets.getAllRecordCount();
            allPageCount = widgets.getAllPageCount();
            currentPageNumber = widgets.getCurrentPageNumber();
            existPrevPage = widgets.isExistPrevPage();
            existNextPage = widgets.isExistNextPage();
            widgetItems = widgets;
            request.getSession().setAttribute(NvWidgetConstants.WIDGET_ITEMS,
                    widgetItems);

            int startIdx = currentPageNumber - 5;
            if (startIdx < 1) {
                startIdx = 1;
            }
            int endIdx = currentPageNumber + 5;
            if (endIdx > allPageCount) {
                endIdx = allPageCount;
            }
            pageItems = new ArrayList<Integer>();
            for (int i = startIdx; i <= endIdx; i++) {
                pageItems.add(i);
            }

            return "index.jsp";
        } catch (NvWidgetException e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(
                    "errors.could_not_load_widget_info");
        }
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "setcategory/{category}")
    public String find() {
        nvWidgetPager.reset();
        nvWidgetPager.setCategory(editForm.category);
        nvWidgetPager.setQuery(editForm.query);
        nvWidgetPager.setRegion(editForm.region);
        return index();
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "list/{pageNumber}")
    public String list() {
        try {
            nvWidgetPager.setPage(Integer.parseInt(editForm.pageNumber));
        } catch (NumberFormatException e) {
            // nothing
        }
        return index();
    }

    @Execute(validator = false, input = "error.jsp")
    public String change() {
        try {
            NvWidgetUtil.changeHeight(request, editForm.height);
            NvWidgetUtil.addMessage(request, "success.update_height");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(
                    "errors.failed_to_update_because_of_system_error");
        }
        return index();
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "update/{id}")
    public String update() {
        if (editForm.id == null) {
            throw new ActionMessagesException(
                    "errors.failed_to_update_because_of_no_id");
        }

        widgetItems = (List<NvWidget>) request.getSession().getAttribute(
                NvWidgetConstants.WIDGET_ITEMS);
        if (widgetItems == null) {
            throw new ActionMessagesException(
                    "errors.failed_to_update_because_of_no_session");
        }

        widgetItems = (List<NvWidget>) HotdeployUtil.rebuildValue(widgetItems);

        boolean isUpdate = false;
        for (NvWidget widget : widgetItems) {
            if (widget.getId().equals(editForm.id)) {
                try {
                    NvWidgetUtil.store(request, widget);
                    NvWidgetUtil.addMessage(request, "success.update_widget");
                    isUpdate = true;
                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                    throw new ActionMessagesException(
                            "errors.failed_to_update_because_of_system_error");
                }
            }
        }

        if (!isUpdate) {
            throw new ActionMessagesException(
                    "errors.failed_to_update_because_of_no_object");
        }

        return index();
    }

    @Execute(validator = false, input = "error.jsp")
    public String prev() {
        int start = nvWidgetPager.getPage();
        start--;
        if (start < 1) {
            start = 1;
        }
        nvWidgetPager.setPage(start);
        return index();
    }

    @Execute(validator = false, input = "error.jsp")
    public String next() {
        int start = nvWidgetPager.getPage();
        start++;
        nvWidgetPager.setPage(start);
        return index();
    }

    public NvWidgetService getNvWidgetService() {
        return nvWidgetService;
    }

    public void setNvWidgetService(NvWidgetService widgetService) {
        nvWidgetService = widgetService;
    }

    public NvWidgetPager getNvWidgetPager() {
        return nvWidgetPager;
    }

    public void setNvWidgetPager(NvWidgetPager widgetPager) {
        nvWidgetPager = widgetPager;
    }

    public EditForm getEditForm() {
        return editForm;
    }

    public void setEditForm(EditForm editForm) {
        this.editForm = editForm;
    }

    public HttpServletRequest getRequest() {
        return request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}
