package jp.sf.pal.nvwidget.action;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

import jp.sf.pal.nvwidget.NvWidgetConstants;
import jp.sf.pal.nvwidget.util.NvWidgetUtil;

import org.seasar.struts.annotation.Execute;
import org.seasar.struts.exception.ActionMessagesException;
import org.seasar.struts.portlet.util.PortletUtil;

public class ViewAction implements Serializable {

    private static final long serialVersionUID = 1L;

    public String id;

    public String url;

    public String height = "250";

    private transient HttpServletRequest request;

    @Execute(validator = false, input = "error.jsp")
    public String index() {
        String value = null;
        try {
            value = URLEncoder.encode(NvWidgetUtil.getPreferenceValue(request,
                    NvWidgetConstants.URL, ""), "UTF-8");
        } catch (UnsupportedEncodingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        if (value == null) {
            throw new ActionMessagesException("errors.invalid_portlet_state");
        } else if ("".equals(value)) {
            NvWidgetUtil.addMessage(request, "warn.need_to_set_widget_url");
            return "error.jsp";
        }
        this.url = value;

        value = NvWidgetUtil.getPreferenceValue(request, NvWidgetConstants.ID,
                "");
        if (value == null) {
            throw new ActionMessagesException("errors.invalid_portlet_state");
        } else if ("".equals(value)) {
            NvWidgetUtil.addMessage(request, "warn.need_to_set_widget_id");
            return "error.jsp";
        }
        this.id = value;

        value = NvWidgetUtil.getPreferenceValue(request,
                NvWidgetConstants.HEIGHT, "250");
        if (value == null) {
            throw new ActionMessagesException("errors.invalid_portlet_state");
        }
        this.height = value;

        setPortletTitle();

        return "index.jsp";
    }

    private void setPortletTitle() {
        RenderResponse renderResponse = PortletUtil.getRenderResponse(request);
        if (renderResponse != null) {
            String value = NvWidgetUtil.getPreferenceValue(request,
                    NvWidgetConstants.NAME, "");
            if (!"".equals(value)) {
                renderResponse.setTitle(value);
            }
        }
    }

    public HttpServletRequest getRequest() {
        return request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}
