package jp.sf.pal.nvwidget.util;

import java.io.IOException;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import javax.servlet.http.HttpServletRequest;

import jp.sf.pal.nvwidget.NvWidgetConstants;
import jp.sf.pal.nvwidget.entity.NvWidget;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.seasar.struts.portlet.util.PortletUtil;
import org.seasar.struts.util.ActionMessagesUtil;

public class NvWidgetUtil {
    public static void addMessage(HttpServletRequest request, String key) {
        ActionMessages msgs = new ActionMessages();
        msgs.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(key));
        ActionMessagesUtil.saveMessages(request, msgs);
    }

    public static String getPreferenceValue(HttpServletRequest request,
            String key, String defaultValue) {
        PortletRequest portletRequest = (PortletRequest) request
                .getAttribute(PortletUtil.PORTLET_REQUEST);
        if (portletRequest != null) {
            PortletPreferences preferences = portletRequest.getPreferences();
            return preferences.getValue(key, defaultValue);
        }
        return null;
    }

    public static String changeHeight(HttpServletRequest request, String height)
            throws ValidatorException, IOException, ReadOnlyException {
        PortletRequest portletRequest = (PortletRequest) request
                .getAttribute(PortletUtil.PORTLET_REQUEST);
        if (portletRequest != null) {
            PortletPreferences preferences = portletRequest.getPreferences();
            preferences.setValue(NvWidgetConstants.HEIGHT, height);
            preferences.store();
        }
        return null;
    }

    public static String store(HttpServletRequest request, NvWidget nvWidget)
            throws ValidatorException, IOException, ReadOnlyException {
        PortletRequest portletRequest = (PortletRequest) request
                .getAttribute(PortletUtil.PORTLET_REQUEST);
        if (portletRequest != null) {
            PortletPreferences preferences = portletRequest.getPreferences();
            preferences.setValue(NvWidgetConstants.ID, nvWidget.getId());
            preferences.setValue(NvWidgetConstants.NAME, nvWidget.getName());
            preferences.setValue(NvWidgetConstants.DESCRIPTION, nvWidget
                    .getDescription());
            preferences.setValue(NvWidgetConstants.URL, nvWidget.getUrl());
            preferences.setValue(NvWidgetConstants.THUMBNAIL, nvWidget
                    .getThumbnail());
            preferences.store();
        }
        return null;
    }
}
