/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.command.client;

import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.TCPClientCommand;
import jp.valtech.bts.util.Logging;

/**
 * メッセージを送信します。
 * このコマンドでメッセージを送信します。送信できるメッセージの数はひとつのみです。
 * 課題票の送信にはTCP通信が使用されます。
 * 
 * @see			jp.valtech.bts.command.server.SendMessageServer
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class SendMessage extends TCPClientCommand implements Logging {

	/** 送信する課題票 */
	private MessagePacket messagePacket = null;
	
	/**
	 * クライアントコマンド生成
	 * 
	 * @param		config 		設定情報
	 * @param		host		送信先ホスト名
	 * @param		port 		送信先ポート番号
	 */
	public SendMessage( NetworkConfig myconfig, String host, int port ) {
		super( myconfig, host, port );
	}

	
	/**
	 * このインスタンスにメッセージオブジェクトを設定します。
	 * @param		messagePacket		メッセージオブジェクト
	 */
	public void setMessagePacket(MessagePacket messagePacket) {
		this.messagePacket = messagePacket;
	}
	
	
	/**
	 * メッセージを送信します。
	 * 送信結果は{@link TCPClientCommand#isSuccessful()}にて取得します。
	 * 
	 */
	public void execute() throws Exception {

		// 課題票が設定されてなかったら何もしません。
		if( this.messagePacket == null ){
			return;
		}

		// 送信オブジェクトを生成
		Request request = new Request();
		
		// コマンド名を設定
		request.setCommand( "sendMessage" );

		// 送信するものを格納
		request.addParameter( "message", this.messagePacket );
		
		// 送信～受信をおこないます。
		send( request );
	}
}
