/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.io.Serializable;


/**
 * <dl><dt><b>添付ファイル</b></dt>
 * 	<dd></dd>
 * </dl>
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class Attachment implements Serializable {

	/** シリアルID　*/
	private static final long serialVersionUID = 1949484121264986914L;

	/** 保存済みかどうかのフラグ。true--保存済み、false--未保存 */
	private boolean registed = true; 
	
	/** 課題票のFingerPrint  */
	private String	fingerPrint = null;

	/** 課題票種別  */
	private String	type = null;

	/** ファイル名(画面表示用) :  */
	private String	displayName = null;

	/** ファイルのフルパス :  */
	private String realPath = null;

	/** ファイル実体 :  */
	private byte[]	attachmentFile = null;


	public Attachment() {
		
	}
	
	/**
	 * <DL>
	 * <DT><B>指紋 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 指紋 
	 */
	public String getFingerPrint() {
		return this.fingerPrint;
	}

	/**
	 * <DL>
	 * <DT><B>指紋を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param fingerPrint 指紋
	 */
	public void setFingerPrint( String fingerPrint ) {
		this.fingerPrint = fingerPrint;
	}
	/**
	 * <DL>
	 * <DT><B>ファイル名 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return ファイル名 
	 */
	public String getDisplayName() {
		return this.displayName;
	}

	/**
	 * <DL>
	 * <DT><B>ファイル名を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param fileName ファイル名
	 */
	public void setDisplayName( String fileName ) {
		this.displayName = fileName;
	}
	/**
	 * <DL>
	 * <DT><B>ファイル実体 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return ファイル実体 
	 */
	public byte[] getAttachmentFile() {
		return this.attachmentFile;
	}

	/**
	 * <DL>
	 * <DT><B>ファイル実体を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param attachmentFile ファイル実体
	 */
	public void setAttachmentFile( byte[] attachmentFile ) {
		this.attachmentFile = attachmentFile;
	}

	public String getType() {
		return type;
	}

	public void setType(String issueType) {
		this.type = issueType;
	}

	public String getRealPath() {
		return realPath;
	}

	public void setRealPath(String realFilePath) {
		this.realPath = realFilePath;
	}

	public boolean isRegisted() {
		return registed;
	}

	public void setRegisted(boolean registed) {
		this.registed = registed;
	}


	/**
	 * 同じ添付ファイル情報かどうかを比較します。
	 * 
	 */
	public boolean equals(Object obj) {
		if(obj==this) {
			return true;
		}

		// Attachmentインスタンスかどうかを確認
		if(obj instanceof Attachment) {
			Attachment that = (Attachment)obj;
			
			// 比較用キー文字列取得
			String thisKey = realPath;
			String thatKey = that.getRealPath();
			
			return thisKey.equals(thatKey);
		}
		return false;
	}

}