/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.io.Serializable;
import java.util.Date;


/**
 * <dl><dt><b>コメント履歴一覧</b></dt>
 * 	<dd></dd>
 * </dl>
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class CommentHistory implements Serializable {

	
	/** シリアルID　*/
	private static final long serialVersionUID = -6198180397159965317L;

	/** 指紋 : 課題票を一意に識別するためのSHA-1フィンガープリント */
	protected String fingerPrint = "";
	
	/** 課題票の種別 */
	protected String type = "";

	/** コメント詳細 :  */
	protected String description = "";

	/** レコード更新者 : このレコードを最後に更新したユーザID */
	protected String updateUser = "";

	/** レコード更新タイムスタンプ : このレコードを最後に更新した日時のタイムスタンプ */
	protected Date updateDate = null;

	
	public CommentHistory() {
		;
	}

	/**
	 * <DL>
	 * <DT><B>指紋 を戻します。</B></B>
	 * </DL>
	 * @return 指紋 
	 */
	public String getFingerPrint() {
		return this.fingerPrint;
	}

	/**
	 * <DL>
	 * <DT><B>指紋を設定します。</B></DT>
	 * </DL>
	 * @param fingerPrint 指紋
	 */
	public void setFingerPrint( String fingerPrint ) {
		this.fingerPrint = fingerPrint;
	}
	
	
	
	/**
	 * <DL>
	 * <DT><B>課題票タイプを戻します。</B></B>
	 * </DL>
	 * @return 課題票タイプ 
	 */
	public String getType() {
		return type;
	}

	/**
	 * <DL>
	 * <DT><B>課題票タイプを設定します。</B></DT>
	 * </DL>
	 * @param type 課題票タイプ
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * <DL>
	 * <DT><B>コメント詳細 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return コメント詳細 
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * <DL>
	 * <DT><B>コメント詳細を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param commentDescription コメント詳細
	 */
	public void setDescription( String description ) {
		this.description = description;
	}
	/**
	 * <DL>
	 * <DT><B>レコード更新者 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return レコード更新者 
	 */
	public String getUpdateUser() {
		return this.updateUser;
	}

	/**
	 * <DL>
	 * <DT><B>レコード更新者を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param updateUser レコード更新者
	 */
	public void setUpdateUser( String updateUser ) {
		this.updateUser = updateUser;
	}
	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ に日時情報を設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param updateDate        レコード更新タイムスタンプ に指定する日時オブジェクト
	 */
	public void setUpdateDate( Date updateDate ){
		if( updateDate != null ){
			this.updateDate = new Date( updateDate.getTime() );
		}
	}

	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ に日時情報をlong型のタイムスタンプで設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param timestamp   レコード更新タイムスタンプ に指定するlong型のタイムスタンプ
	 */
	public void setUpdateDate( long timestamp ){
		this.updateDate = new Date( timestamp );
	}

	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ を取得。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @return レコード更新タイムスタンプ
	 */
	public Date getUpdateDate(){
		return this.updateDate;
	}

	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ をlongのタイムスタンプで取得</B></DL>
	 *  <DD>レコード更新タイムスタンプ の日付情報をlongのタイムスタンプで取得します。
	 * レコード更新タイムスタンプ がnullの場合、NullPointerExceptionが発生することに注意してください。</DD>
	 * </DL>
	 * @return レコード更新タイムスタンプ のタイムスタンプ(long)
	 */
	public long getUpdateDateTimestamp(){
		return this.updateDate.getTime();
	}


}