/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.beans.XMLEncoder;

/**
 * {@link XMLEncoder}を利用して課題票詳細をXMLに出力するためのJavaBeansクラスです。
 * {@link XMLEncoder}を利用するにはデフォルトコンストラクタが存在しなければなりません。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class OutputDetails {

	/** 課題票ID */
	private String issueId;
	
	/** 起票者 */
	private String createUser;
	
	/** カテゴリ */
	private String category;
	
	/** タイトル */
	private String title;
	
	/** 詳細 */
	private String description;
	
	/** 優先度 */
	private String priority;
	
	/** ステータス */
	private String status;
	
	/** 担当者 */
	private String assigned;
	
	/** 完了期限 */
	private String deadLine;
	
	/** 内緒のバグ */
	private String secretBug;
	
	/** 一時保留 */
	private String suspend;
	
	private String attach;
	
	/** 起票日時 */
	private String createDate;
	
	/** 更新日時 */
	private String updateDate;
	
	/** ヘッダ文字列 */
	private String header;
	
	/** フッタ文字列 */
	private String footer;
	
	
	/**
	 * デフォルトコンストラクタです。
	 */
	public OutputDetails() {
	}


	/**
	 * @return assigned を戻します。
	 */
	public String getAssigned() {
		return assigned;
	}


	/**
	 * @param assigned 設定する assigned。
	 */
	public void setAssigned(String assigned) {
		this.assigned = assigned;
	}


	/**
	 * @return attach を戻します。
	 */
	public String getAttach() {
		return attach;
	}


	/**
	 * @param attach 設定する attach。
	 */
	public void setAttach(String attach) {
		this.attach = attach;
	}


	/**
	 * @return category を戻します。
	 */
	public String getCategory() {
		return category;
	}


	/**
	 * @param category 設定する category。
	 */
	public void setCategory(String category) {
		this.category = category;
	}


	/**
	 * @return createDate を戻します。
	 */
	public String getCreateDate() {
		return createDate;
	}


	/**
	 * @param createDate 設定する createDate。
	 */
	public void setCreateDate(String createDate) {
		this.createDate = createDate;
	}


	/**
	 * @return createUser を戻します。
	 */
	public String getCreateUser() {
		return createUser;
	}


	/**
	 * @param createUser 設定する createUser。
	 */
	public void setCreateUser(String createUser) {
		this.createUser = createUser;
	}


	/**
	 * @return deadLine を戻します。
	 */
	public String getDeadLine() {
		return deadLine;
	}


	/**
	 * @param deadLine 設定する deadLine。
	 */
	public void setDeadLine(String deadLine) {
		this.deadLine = deadLine;
	}


	/**
	 * @return description を戻します。
	 */
	public String getDescription() {
		return description;
	}


	/**
	 * @param description 設定する description。
	 */
	public void setDescription(String description) {
		this.description = description;
	}


	/**
	 * @return footer を戻します。
	 */
	public String getFooter() {
		return footer;
	}


	/**
	 * @param footer 設定する footer。
	 */
	public void setFooter(String footer) {
		this.footer = footer;
	}


	/**
	 * @return header を戻します。
	 */
	public String getHeader() {
		return header;
	}


	/**
	 * @param header 設定する header。
	 */
	public void setHeader(String header) {
		this.header = header;
	}


	/**
	 * @return issueId を戻します。
	 */
	public String getIssueId() {
		return issueId;
	}


	/**
	 * @param issueId 設定する issueId。
	 */
	public void setIssueId(String issueId) {
		this.issueId = issueId;
	}


	/**
	 * @return priority を戻します。
	 */
	public String getPriority() {
		return priority;
	}


	/**
	 * @param priority 設定する priority。
	 */
	public void setPriority(String priority) {
		this.priority = priority;
	}


	/**
	 * @return secretBug を戻します。
	 */
	public String getSecretBug() {
		return secretBug;
	}


	/**
	 * @param secretBug 設定する secretBug。
	 */
	public void setSecretBug(String secretBug) {
		this.secretBug = secretBug;
	}


	/**
	 * @return status を戻します。
	 */
	public String getStatus() {
		return status;
	}


	/**
	 * @param status 設定する status。
	 */
	public void setStatus(String status) {
		this.status = status;
	}


	/**
	 * @return suspend を戻します。
	 */
	public String getSuspend() {
		return suspend;
	}


	/**
	 * @param suspend 設定する suspend。
	 */
	public void setSuspend(String suspend) {
		this.suspend = suspend;
	}


	/**
	 * @return title を戻します。
	 */
	public String getTitle() {
		return title;
	}


	/**
	 * @param title 設定する title。
	 */
	public void setTitle(String title) {
		this.title = title;
	}


	/**
	 * @return updateDate を戻します。
	 */
	public String getUpdateDate() {
		return updateDate;
	}


	/**
	 * @param updateDate 設定する updateDate。
	 */
	public void setUpdateDate(String updateDate) {
		this.updateDate = updateDate;
	}


}
