/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.network;


/**
 * レスポンスオブジェクト。
 * 受信側から返される通信結果を格納したオブジェクトです。
 * 
 * @author		<A href="mailto:iinuma@valtech.jp">K.Iinuma</A>
 * @version	Ver.0.8
 */
public class Response extends TransData{


	/** シリアルID　*/
	private static final long serialVersionUID = 3418233064402251692L;

	/** 失敗コード */
	public static final String	ERROR	= "error";
	
	/** 成功コード */
	public static final String	OK		= "okay";

	/** レスポンスコード */
	private String	code				= null;

	/** レスポンスメッセージ */
	private String	message		= "failed server process";

	/**
	 * <DL><DT><B>レスポンスコードを戻します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @return レスポンスコード
	 */
	public String getCode() {
		return this.code;
	}

	/**
	 * <DL><DT><B>レスポンスコードを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param code レスポンスコード。
	 */
	public void setCode( String code ) {
		this.code = code;
	}

	/**
	 * <DL><DT><B>メッセージを戻します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @return メッセージ 
	 */
	public String getMessage() {
		return message;
	}


	/**
	 * <DL><DT><B>メッセージを追加します。</B></DT>
	 *  <DD></DD>
	 * </DL>
	 * @param		message			メッセージ文字列
	 */
	public void setMessage( String message ){
		this.message = message;
	}

}
