/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.facade.MessagePacketFacade;
import jp.valtech.bts.ui.BtsPlugin;

import org.eclipse.jface.action.Action;

/**
 * メッセージを削除するアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class DeleteMessageAction extends Action {

	/** メッセージインスタンス */
	private MessagePacket message;

	/**
	 * 呼び出し元のビューインスタンスを設定します。
	 * 
	 * @param		view			 呼び出し元のビューインスタンス
	 */
	public DeleteMessageAction() {
		super();
		setText(Messages.getString("DeleteMessageAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("DeleteMessageAction.1"));  //$NON-NLS-1$
		setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("delete.gif"));
	}
	
	/**
	 * メッセージを削除します。
	 */
	public void run() {
		
		MessagePacketFacade facade = new MessagePacketFacade();
		facade.deleteByMessageID(message);
	}
	
	/**
	 * メッセージを設定します。
	 * 
	 * @param		message			メッセージ
	 */
	public void setMessagePacket(MessagePacket message) {
		this.message = message;
	}
}
