/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.issuelist;

import java.text.SimpleDateFormat;

import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueStatus;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.BTSUtility;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/**
 * 課題票一覧を表示するテーブルのラベルプロバイダです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class IssueListViewLabelProvider extends LabelProvider implements ITableLabelProvider, IColorProvider {
	
	/** フォーマッタ */
	private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm");
	/** アイコン表示：エラー */
	private static final Image IMG_ERROR = BtsPlugin.getInstance().getImage("error1.gif");
	/** アイコン表示：警告 */
	private static final Image IMG_WARNING = BtsPlugin.getInstance().getImage("warning1.gif");
	/** 表示で使う色：グレー */
	private static final Color COLOR_GRAY = new Color(Display.getCurrent(), 160, 160, 160); 


	/*
	 *  (非 Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
	 */ 
	public String getColumnText(Object obj, int index) {
		Issue issue = (Issue)obj;
		switch (index) {
			// 2カラム目：課題票ID
			case 1:
				return issue.getDisplayIssueID();
			// 3カラム目：タイトル
			case 2:
				return issue.getTitle();
			// 4カラム目：カテゴリ
			case 3:
				return issue.getCategory();
			// 5カラム目：優先度
			case 4:
				return issue.getPriority();
			// 6カラム目：ステータス
			case 5:
				IssueStatus issueStatus = IssueStatus.getEnumFromValue(issue.getStatus());
				return issueStatus.getDescription() ;
			// 7カラム目：担当者
			case 6:
				return issue.getAssigned();
			// 8カラム目：起票日
			case 7:
				if(issue.getCreateDate() ==null) {
					return "";
				}
				return FORMATTER.format(issue.getCreateDate()); 
		}
		return "";
	}
	
	/*
	 *  (非 Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
	 */
	public Image getColumnImage(Object obj, int index) {
		
		Issue issue = (Issue)obj;
		
		switch (index) {
		
			// 1カラム目：完了期限アイコン
			case 0:
				
				// 完了期限を判定
				int judge = BTSUtility.judgeLimit(issue);
				
				// 完了期限切れの場合
				if(judge == Issue.DEADLINE_OVER) {
					return IMG_ERROR;
				}
				
				// 完了期限が迫っている場合
				else if(judge == Issue.DEADLINE_WARNING) {
					return IMG_WARNING;
				}
				
		}
		return null;
	}

	/* (非 Javadoc)
	 * @see org.eclipse.jface.viewers.IColorProvider#getBackground(java.lang.Object)
	 */
	public Color getBackground(Object element) {
		return null;
	}

	/* (非 Javadoc)
	 * @see org.eclipse.jface.viewers.IColorProvider#getForeground(java.lang.Object)
	 */
	public Color getForeground(Object element) {
		Issue issue = (Issue)element;
		
		if(IssueStatus.CLOSED_VALUE.equals( issue.getStatus()) ) {
			return COLOR_GRAY;
		}
		return null;
	}

}
