/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.navigator;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

/**
 * {@link IDialogSettings}に保存したセクションを削除するメソッドを追加したインタフェース。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public interface IProjectDialogSettings {

    public IProjectDialogSettings addNewSection(String name);

    public void addSection(IProjectDialogSettings section);

    public String get(String key);

    public String[] getArray(String key);

    public boolean getBoolean(String key);

    public double getDouble(String key) throws NumberFormatException;

    public float getFloat(String key) throws NumberFormatException;

    public int getInt(String key) throws NumberFormatException;

    public long getLong(String key) throws NumberFormatException;

    public String getName();

    public IProjectDialogSettings getSection(String sectionName);

    public IProjectDialogSettings[] getSections();

    public void load(Reader reader) throws IOException;

    public void load(String fileName) throws IOException;

    public void put(String key, String[] value);

    public void put(String key, double value);

    public void put(String key, float value);

    public void put(String key, int value);

    public void put(String key, long value);

    public void put(String key, String value);

    public void put(String key, boolean value);

    public void save(Writer writer) throws IOException;

    public void save(String fileName) throws IOException;
    
    
    /**
     * 追加したメソッド。
     * 指定されたセクションのプロジェクト情報を削除します。
     * 
     * @param sectionName
     */
	public void removeSection(String sectionName);
	
}
