/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.navigator;

import jp.valtech.bts.ui.BtsPlugin;

import org.eclipse.swt.graphics.Image;



/**
 * プロジェクトノードです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class ProjectNode extends BtsTreeNode implements IFolderNode {
    
	/** このノードのアイコン：プロジェクトオープン */
	private static final Image IMAGE_OPEN = BtsPlugin.getInstance().getImage("project.gif"); 
	/** このノードのアイコン：プロジェクトクローズ */
	private static final Image IMAGE_CLOSE = BtsPlugin.getInstance().getImage("project_close.gif"); 

	/** プロジェクトのSSID */
	private String ssid;

	/**
     * 親ノード・ラベルを設定します。
     * 
     * @param		parent				このノードの親
     * @param		textName			このノードのラベル
     * @param		ssid				プロジェクトのSSID
     */
    public ProjectNode(BtsTreeNode parent, String textName, String ssid) {
    	super(parent, textName, IMAGE_CLOSE);
    	this.ssid = ssid;
    }
    
    /**
     * プロジェクトのオープン
     */
    public void open() {
    	image = IMAGE_OPEN;
    }
    
    /**
     * プロジェクトのクローズ
     */
    public void close() {
    	image = IMAGE_CLOSE;
    	this.children.clear();
    }


	/**
	 * SSIDを取得します。
	 * 
	 * @return		SSID
	 */
	public String getSSID() {
		return ssid;
	}
	
	/**
	 * 当ノードが持っているはずの{@link MemberListNode 参加者リストノード}を返します。
	 * 
	 * @return		参加者リストノード
	 */
	public ReleaseNode getReleaseNode() {
		for (int idx = 0; idx < children.size(); idx++) {
			BtsTreeNode child = (BtsTreeNode)children.get(idx);
			if(child instanceof ReleaseNode) {
				return (ReleaseNode)child;
			}
		}
		return null;
	}
	
	/**
	 * 当ノードが持っているはずの{@link MemberListNode 参加者リストノード}を返します。
	 * 
	 * @return		参加者リストノード
	 */
	public MemberListNode getMemberListNode() {
		for (int idx = 0; idx < children.size(); idx++) {
			BtsTreeNode child = (BtsTreeNode)children.get(idx);
			if(child instanceof MemberListNode) {
				return (MemberListNode)child;
			}
		}
		return null;
	}

	/**
	 * 当ノードが持っているはずの{@link DraftNode 下書きフォルダノード}を返します。
	 * 
	 * @return		下書きフォルダノード
	 */
	public DraftNode getDraftNode() {
		for (int idx = 0; idx < children.size(); idx++) {
			BtsTreeNode child = (BtsTreeNode)children.get(idx);
			if(child instanceof DraftNode) {
				return (DraftNode)child;
			}
		}
		return null;
	}
	

	/**
	 * 当ノードが持っているはずの{@link ConflictNode 競合フォルダノード}を返します。
	 * 
	 * @return		競合フォルダノード
	 */
	public ConflictNode getConflictNode() {
		for (int idx = 0; idx < children.size(); idx++) {
			BtsTreeNode child = (BtsTreeNode)children.get(idx);
			if(child instanceof ConflictNode) {
				return (ConflictNode)child;
			}
		}
		return null;
	}
	
	
	/**
	 * 当ノードが持っているはずの{@link GarbageBoxNode ごみばこノード}を返します。
	 * 
	 * @return		ごみばこノード
	 */
	public GarbageBoxNode getGarbageBoxNode() {
		for (int idx = 0; idx < children.size(); idx++) {
			BtsTreeNode child = (BtsTreeNode)children.get(idx);
			if(child instanceof GarbageBoxNode) {
				return (GarbageBoxNode)child;
			}
		}
		return null;
	}

	
	/**
	 * ソートキーを返します。
	 * 
	 * @return		このノードのソートキー
	 */
	public String getFolderSortKey() {
		return textName;
	}


	/*
	 *  (非 Javadoc)
	 * @see jp.valtech.bts.ui.navigator.BtsTreeNode#getNodeKey()
	 */
	public String getNodeKey() {
		return ssid;
	}

}
