/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.navigator;

import jp.valtech.bts.ui.BtsPlugin;

import org.eclipse.swt.graphics.Image;



/**
 * 下書き保存の課題票を格納するフォルダノードです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class ReleaseNode extends BtsTreeNode implements ISecondNode, IFolderNode {
    
	/** このノードのイメージファイル */
	private static final Image IMAGE = BtsPlugin.getInstance().getImage("release.gif"); 
	
	/** このノードの表示名 */
	private static final String TEXT_NAME = Messages.getString("ReleaseNode.0");  //$NON-NLS-1$
	
	/** このノードのソートキー */
	private static final String SORT_KEY = "001";


	/**
     * 親ノード・ラベルを設定します。
     * 
     * @param		parent				このノードの親
     */
    public ReleaseNode(BtsTreeNode parent) {
    	super(parent, TEXT_NAME, IMAGE);
    }
    
	/**
	 * 当ノードが持っているはずの{@link CategoryNode カテゴリフォルダノード}を返します。
	 * カテゴリノードは複数あるので、指定したカテゴリ名と同じ名前のカテゴリノードを返します。
	 * 
	 * @param		ctgryName			カテゴリ名
	 * @return		指定したカテゴリ名を持つカテゴリノード
	 */
	public CategoryNode getCategoryNode(String ctgryName) {
		if(ctgryName == null) {
			return null;
		}
		for (int idx = 0; idx < children.size(); idx++) {
			BtsTreeNode child = (BtsTreeNode)children.get(idx);
			if(child instanceof CategoryNode) {
				CategoryNode ctgryNode = (CategoryNode)child; 
				if( ctgryName.equals( ctgryNode.getTextName()) ) {
					return ctgryNode;
				}
			}
		}
		return null;
	}

	/**
	 * ソートキーを返します。
	 * 
	 * @return		このノードのソートキー
	 */
	public String getFolderSortKey() {
		return SORT_KEY;
	}

	/*
	 *  (非 Javadoc)
	 * @see jp.valtech.bts.ui.navigator.AbstractTreeNode#compareTo(java.lang.Object)
	 */
	public int compareTo(Object obj) {
		if(obj instanceof ReleaseNode) {
			ISecondNode that = (ISecondNode)obj;
			String thisKey = this.getFolderSortKey();
			String thatKey = that.getFolderSortKey();
			return thisKey.compareTo(thatKey);
		}
		return -1;
	}

}
