package distance;
// poisson distance

public class Poi_dis extends dis{ 
    public String name() {return "Po";} 
 
    public double dk()  throws ArithmeticException{ 
    	// returns dk/dp, where k = -log(1-p);
        if(!set) throw new ArithmeticException("Poisson: not set yet!");
        return 1/(1-p); //biased!?
    }
 
    public double dp()  throws ArithmeticException{ 
        if(!set) throw new ArithmeticException("Poisson: not set yet!");
        return (p-1); //unbiased
    }

    void set_p(int P, int seq_len) { 
        p= ((double)P / (double) seq_len);
        set = true;
        k = unbiased(P,seq_len); // number of substitutions per site
    }
 
    double unbiased(int P,int seq_len) throws ArithmeticException{ 
    	// number of substitutions (not per site)
        UB2 = TableMan.init_2D(seq_len,P,UB2);
        if (UB2[seq_len][P]<0){ // if not initialized, calculate.
            double total=0;
            // ܂Ă̂͊mFA2009/5/19
            for(int j=1;j<=P;j++){
                double ln = 1;
                ln = fact.lnP(P,j) - ( Math.log(j) +  fact.lnP(len,j) ); //tajima 1993
                total += Math.exp( ln );  // to avoid overflow
            }
            if( Double.isNaN(total)||Double.isInfinite(total) ){ //inapplicable*/
                System.err.println("out of range");
                double q = ((double) P) / ((double) seq_len);
                total = - Math.log(1-q);
            }
            UB2[seq_len][P]=total;
        }
        return UB2[seq_len][P];
    }
    


    

    double Vpinv() throws ArithmeticException { 
    //    if(Vk()>0) return 1/Vk();
   	 //N̘_Ȃ͂
   	double K = p*len;
       if(!set) throw new ArithmeticException("not set yet!");
       double E1 = 1 /(K+1); // Haldane
       double E2 = 1 /(len-K+1); // Haldane
       return (E1+E2)*len*len;
   }
    
    
    public double Vp() throws ArithmeticException { 
        if(!set) throw new ArithmeticException("not set yet!");
        return p*(1-p)/len;
    }

   public double Vk() throws ArithmeticException { 
       if(!set) throw new ArithmeticException("not set yet!");
       return Vp()*dk()*dk();
   }

   public double Vkinv() throws ArithmeticException { 
   	if(!set) throw new ArithmeticException("not set yet!");
       return Vpinv()*dp()*dp();
   }
   public void set_seq(String seq1, String seq2) throws ArithmeticException { 
       int l = seq1.length();
       if(l<=1){
           set = true;
           existence = false;
           return ;
       }
       if(isComparable(seq1,seq2)){
           int diff = 0;
           if (seq2.length()<l) l = seq2.length();
   //        set_len(l);
           len = l;
           for(int i=0;i<len;i++)
               if (seq1.charAt(i) != seq2.charAt(i) ) diff++;
   //        set_p((double)diff / (double) len);
           set_p( diff , len);
           set = true;
           existence = true;
           return;
       }
       set = true;
       existence = false;
   }
}