package distance;
// Poisson + gamma

public class Poi_gam_dis extends Poi_dis{
    public double alpha;
    public Poi_gam_dis(){alpha=0.65;}
    public Poi_gam_dis(double alpha0){alpha=alpha0;}
    public String name() {return "PG";} 
    public double dk()  throws ArithmeticException{ 
        if(!set) throw new ArithmeticException("Poisson: not set yet!");
        return -1/(1-p); //biased!?
    }
 
    public double dp()  throws ArithmeticException{ 
        if(!set) throw new ArithmeticException("Poisson: not set yet!");
        return (p-1); //unbiased
    }


    double unbiased(int P, int seq_len) throws ArithmeticException{ //not unbiased
        p = (P+0.0)/(seq_len+0.0);
        return (alpha* (Math.exp( Math.log(1-p)*(-1/alpha) ) - 1));
/*
        UB2 = tableman.init_2D(seq_len,P,UB2);
        if (UB2[seq_len][P]<0){ // if not initialized, calculate.
            double total=0;
            for(int j=1;j<=P;j++){
                double ln = 1;
                ln = fact.lnP(P,j) - ( Math.log(j) +  fact.lnP(len,j) ); //tajima 1993
                total += Math.exp( ln );  // to avoid overflow
            }
            if( Double.isNaN(total)||Double.isInfinite(total) ){ //inapplicable
                System.err.println("out of range");
                double q = ((double) P) / ((double) seq_len);
                total = - Math.log(1-q);
            }
            UB2[seq_len][P]=total;
        }
        return UB2[seq_len][P];
*/
    }
}


