package main;



//Copyright Kazuharu Misawa June 13 2001
//This program is distributed under the terms of the GNU General Public License 
import java.io.*;
import java.util.*;

import node.*;
import io.*;
import parameters.parameters;
//bootstrapNX
//convert newick tree (this(kind,of)data) to node

public class ManyTrees{ 
	public Hashtable<String, Integer> bootNo;
	public Hashtable<String, Double> SumBranchLen;
	public Hashtable<String, Integer> topologyNo;
	public int repeatNo;
	public String outgroup;
	
	public static void main(String[] args)throws FileNotFoundException,IOException {
		if(args.length==0) return ;
		String[] org = newickTree.convert(fileload.loadLine0(args[0]));
		String[] data = org;
		String type = "topology";
		if(args.length>1){
			data = newickTree.convert(fileload.loadLine0(args[1]));
			type = "branch";
		}
		int NoRep=data.length; // number of bootstrap resampling
		Hashtable<String, node> table =new Hashtable<String, node>();
		node orgtree = newickTree.newick2tree(org[0]);
	}

	public static String bootStrap(String org, String[] data, parameters params){
		String outgroupName = params.OTUName[0];
		int NoRep=data.length; // number of bootstrap resampling
		//orgnode֕ϊ
		node orgtree = newickTree.newick2tree(org);
		//OTUQbg
		//AEgO[vZbg
		node tree2 = orgtree.setRoot(outgroupName);
		
		//}牺OTUSĂ̖OׂStringɑ΂
		//String̏opxoĂHashtable

		//ManyTrees^bootɃf[^So
		int datasize = data.length;
		ManyTrees boot = new ManyTrees(outgroupName);
		for(int i=0;i<datasize;i++){
			boot.oneRepeat(data[i]);
		}
	    //܂łOK 6/10
		Hashtable<String, node> table =new Hashtable<String, node>();
		//tablenɋ
		tree2.putListOnTable(table);
		if(params.percentage.equals("yes")){
			boot.putBootNoPercentage(table,NoRep); // write bootstrap values on the tree
		}else{
			boot.putBootNo(table,NoRep); // write bootstrap values on the tree
		}
		//bootstrapl܂߂ďo
		return tree2.unrootedBootToString();
	}

	public ManyTrees(String out0){
		bootNo=new Hashtable<String, Integer> ();
		SumBranchLen=new Hashtable<String, Double> ();
		topologyNo=new Hashtable<String, Integer> ();
		repeatNo=0;
		outgroup=out0;
	}
	
	public void putBootNo(Hashtable<String, node> table) {
     for (Enumeration e = bootNo.keys() ; e.hasMoreElements() ;) {
         String group = (String) e.nextElement();
         Integer No = bootNo.get(group);
         if( table.containsKey(group) ){
         	(table.get(group)).setBootstrap(No.intValue());
         }
     }		
	}

	public void putBootNo(Hashtable<String, node> table, int NoRep) {
     for (Enumeration e = bootNo.keys() ; e.hasMoreElements() ;) {
         String group = (String) e.nextElement();
         Integer No = bootNo.get(group);
         if( table.containsKey(group) ){
         	(table.get(group)).setBootstrap( (int) (No.intValue() ));
//         	(table.get(group)).setBootstrap( (int) (No.intValue()*100/NoRep ));
        }
     }		
	}

	public void putBootNoPercentage(Hashtable<String, node> table, int NoRep) {
	     for (Enumeration e = bootNo.keys() ; e.hasMoreElements() ;) {
	         String group = (String) e.nextElement();
	         Integer No = bootNo.get(group);
	         if( table.containsKey(group) ){
	         	(table.get(group)).setBootstrap( (int) (No.intValue()*100/NoRep ));
	        }
	     }		
		}


	public void oneRepeat(String NWtree){
		node tree = newickTree.newick2tree(NWtree);
		oneRepeat(tree);
	}

	public void oneRepeat(node tree){
		node tree2 = tree.setRoot(outgroup);
		String[] list = tree2.listOfBranches();//̓\[gĂȂƂ܂
		for(int j=0;j<list.length;j++){
			put(list[j]); // count branches eXgς
		}
//		put2(tree2.topologyToString()); //count topologies
	}
	
	void put(String branchName){
		int n=0;
		if ( bootNo.containsKey(branchName) ){
			Integer N = (Integer) bootNo.get(branchName);
			n=N.intValue();
		}
		n++;
		bootNo.put(branchName, (new Integer(n)) );
    }

	void put2(String branchName){
		int n=0;
		if ( topologyNo.containsKey(branchName) ){
			Integer N = (Integer) topologyNo.get(branchName);
			n=N.intValue();
		}
		n++;
		topologyNo.put(branchName, (new Integer(n)) );
	}

	public void showAverageTree() {
        Vector <Integer> v = new Vector<Integer> ();
    	Hashtable<Integer,String> gyaku = new Hashtable<Integer,String>();
	    for (Enumeration e = topologyNo.keys() ; e.hasMoreElements() ;) {
	        String group = (String) e.nextElement();
	        Integer No = topologyNo.get(group);
	        gyaku.put(No,group);
	        v.add(No);
	    }		
        Integer[] result = new Integer[v.size()];
        v.copyInto(result);
	    Arrays.sort(result);
	    for(int i=result.length-1;i>=0;i--){
	        Integer No = result[i];
	        String group = gyaku.get(No);
	        System.out.print(group);
	        System.out.print("\t");
	        System.out.println(No);
	    }
	}

	public void showTopology() {
        Vector <Integer> v = new Vector<Integer> ();
    	Hashtable<Integer,String> gyaku = new Hashtable<Integer,String>();
	    for (Enumeration e = topologyNo.keys() ; e.hasMoreElements() ;) {
	        String group = (String) e.nextElement();
	        Integer No = topologyNo.get(group);
	        gyaku.put(No,group);
	        v.add(No);
	    }		
        Integer[] result = new Integer[v.size()];
        v.copyInto(result);
	    Arrays.sort(result);
	    for(int i=result.length-1;i>=0;i--){
	        Integer No = result[i];
	        String group = gyaku.get(No);
	        System.out.print(group);
	        System.out.print("\t");
	        System.out.println(No);
	    }
	}

} 
