package modelTree;
//tree4 using node 
//
 
import java.io.*;
import java.util.*;

import sequence.mutagen;

import node.*;
 
public class CopyOfModelTree{ 
    public mutagen mut;
    public double u;
    public int LEN;
    public seq_node root;

    
    public CopyOfModelTree(){ 
    }
    
    public CopyOfModelTree(mutagen mut0, double mu, int len0){ 
        mut = mut0;
        u = mu;
        LEN = len0;
        root = new seq_node(mut0, -1, mu, len0);
         root.set_rate(mu);
    }

    public CopyOfModelTree(mutagen mut0, double mu, int len0, node org_tree){ 
        mut = mut0;
        u = mu;
        LEN = len0;
        root = seq_node.create_seq_node(mut0, org_tree, len0);
        root.set_rate(mu);
    }
 
    public void set_rate(double u0){ // set evolutionary rate; 
        u =  u0;
//        System.out.print("tree:");
//        System.out.println(u);
        root.set_rate(u0);
    }
 
    public void set_mut(mutagen mut0){ // set substitution pattern; 
        root.set_mut(mut0);
        mut = mut0;
    }
 
    public void set_len(int len0){ // set sequence length; 
        root.set_len(len0,u);
        LEN = len0;
    }


}
  

 
class H2 extends CopyOfModelTree{ 
    public H2(mutagen mut0, double mu, int len0){
        super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1, OTU3, OTU2, node1, node2;;
         OTU0  = new seq_node(mut0, 0, 0.5, len0);
         OTU1  = new seq_node(mut0, 1, 0.1, len0);
         node1 = new seq_node(0.05, OTU0, OTU1);
         OTU2  = new seq_node(mut0, 2, 0.5, len0);
         OTU3  = new seq_node(mut0, 3, 0.1, len0);
         node2 = new seq_node(0.05, OTU2, OTU3);
         root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}
 
class H3 extends CopyOfModelTree{ 
    public H3(mutagen mut0, double mu, int len0){
        super(mut0, (double) mu, len0);
        seq_node OTU0, OTU1, OTU2, OTU3, node1, node2;;
        OTU0  = new seq_node(mut0,1, 1.0, len0);
        OTU1  = new seq_node(mut0,2, 0.1, len0);
        node1 = new seq_node(0.05, OTU0, OTU1);
        OTU2  = new seq_node(mut0, 0, 1.0, len0);
        OTU3  = new seq_node(mut0, 3, 0.1, len0);
        node2 = new seq_node(0.05, OTU2, OTU3);
        root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}
 
class K extends CopyOfModelTree{ 
    public K(mutagen mut0, double mu, int len0){
         super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1, OTU3, OTU2, node1, node2;;
         OTU0  = new seq_node(mut0, 0, 0.5, len0);
         OTU1  = new seq_node(mut0, 1, 0.5, len0);
         node1 = new seq_node(0.05, OTU0, OTU1);
         OTU2  = new seq_node(mut0, 2, 0.5, len0);
         OTU3  = new seq_node(mut0, 3, 0.5, len0);
         node2 = new seq_node(0.05, OTU2, OTU3);
         root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}
 
class K3 extends CopyOfModelTree{ 
    public K3(mutagen mut0, double mu, int len0){
         super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1, OTU3, OTU2, node1, node2;;
         OTU0  = new seq_node(mut0, 1, 0.5, len0);
         OTU1  = new seq_node(mut0, 2, 0.5, len0);
         node1 = new seq_node(0.05, OTU0, OTU1);
         OTU2  = new seq_node(mut0, 0, 0.5, len0);
         OTU3  = new seq_node(mut0, 3, 0.5, len0);
         node2 = new seq_node(0.05, OTU2, OTU3);
         root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}

class K4 extends CopyOfModelTree{ 
    public K4(mutagen mut0, double mu, int len0){
         super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1, OTU3, OTU2, node1, node2;;
         OTU0  = new seq_node(mut0, 2, 0.1, len0);
         OTU1  = new seq_node(mut0, 3, 0.1, len0);
         node1 = new seq_node(0.05, OTU0, OTU1);
         OTU2  = new seq_node(mut0, 0, 0.4, len0);
         OTU3  = new seq_node(mut0, 1, 0.3, len0);
         node2 = new seq_node(0.05, OTU2, OTU3);
         root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}

class Ka extends CopyOfModelTree{ 
    public Ka(mutagen mut0, double mu, int len0){
         super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1, OTU3, OTU2, node1, node2;;
         OTU0  = new seq_node(mut0, 2, 0.1, len0);
         OTU1  = new seq_node(mut0, 3, 0.1, len0);
         node1 = new seq_node(0.05, OTU0, OTU1);
         OTU2  = new seq_node(mut0, 0, 0.4, len0);
         OTU3  = new seq_node(mut0, 1, 0.1, len0);
         node2 = new seq_node(0.05, OTU2, OTU3);
         root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}

class Kb extends CopyOfModelTree{ 
    public Kb(mutagen mut0, double mu, int len0){
         super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1, OTU3, OTU2, node1, node2;;
         OTU0  = new seq_node(mut0, 2, 0.1, len0);
         OTU1  = new seq_node(mut0, 3, 0.1, len0);
         node1 = new seq_node(0.05, OTU0, OTU1);
         OTU2  = new seq_node(mut0, 0, 0.4, len0);
         OTU3  = new seq_node(mut0, 1, 0.2, len0);
         node2 = new seq_node(0.05, OTU2, OTU3);
         root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}

class Kc extends CopyOfModelTree{ 
    public Kc(mutagen mut0, double mu, int len0){
         super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1, OTU3, OTU2, node1, node2;;
         OTU0  = new seq_node(mut0, 2, 0.1, len0);
         OTU1  = new seq_node(mut0, 3, 0.1, len0);
         node1 = new seq_node(0.05, OTU0, OTU1);
         OTU2  = new seq_node(mut0, 0, 0.4, len0);
         OTU3  = new seq_node(mut0, 1, 0.3, len0);
         node2 = new seq_node(0.05, OTU2, OTU3);
         root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}

class Kx extends CopyOfModelTree{ 
    public Kx(mutagen mut0, double mu, int len0,double d){
         super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1, OTU3, OTU2, node1, node2;;
         OTU0  = new seq_node(mut0, 2, 0.1, len0);
         OTU1  = new seq_node(mut0, 3, 0.1, len0);
         node1 = new seq_node(0.05, OTU0, OTU1);
         OTU2  = new seq_node(mut0, 0, 0.4, len0);
         OTU3  = new seq_node(mut0, 1, d, len0);
         node2 = new seq_node(0.05, OTU2, OTU3);
         root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}


class Jx extends CopyOfModelTree{ 
    public Jx(mutagen mut0, double mu, int len0,double d){
         super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1, OTU3, OTU2, node1, node2;;
         OTU0  = new seq_node(mut0, 2, d, len0);
         OTU1  = new seq_node(mut0, 3, 0.1, len0);
         node1 = new seq_node(0.05, OTU0, OTU1);
         OTU2  = new seq_node(mut0, 0, 0.4, len0);
         OTU3  = new seq_node(mut0, 1, 0.2, len0);
         node2 = new seq_node(0.05, OTU2, OTU3);
         root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}

class C extends CopyOfModelTree{ 
    public C(mutagen mut0, double mu, int len0){
        super(mut0, (double) mu, len0);
        seq_node OTU0, OTU1, OTU2, OTU3, node1, node2;;
        OTU0  = new seq_node(mut0,0, 1.0, len0);
        OTU1  = new seq_node(mut0,1, 1.0, len0);
        node1 = new seq_node(0.05, OTU0, OTU1);
        OTU2  = new seq_node(mut0, 2, 0.1, len0);
        OTU3  = new seq_node(mut0, 3, 0.1, len0);
        node2 = new seq_node(0.05, OTU2, OTU3);
        root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}
 
class C3 extends CopyOfModelTree{ 
    public C3(mutagen mut0, double mu, int len0){
        super(mut0, (double) mu, len0);
        seq_node OTU0, OTU1, OTU2, OTU3, node1, node2;;
        OTU0  = new seq_node(mut0,1, 1.0, len0);
        OTU1  = new seq_node(mut0,2, 1.0, len0);
        node1 = new seq_node(0.05, OTU0, OTU1);
        OTU2  = new seq_node(mut0, 0, 0.1, len0);
        OTU3  = new seq_node(mut0, 3, 0.1, len0);
        node2 = new seq_node(0.05, OTU2, OTU3);
        root  = new seq_node(0.0, node1, node2);
         root.set_rate(mu);
    }
}
 
class A2 extends CopyOfModelTree{ 
    public A2(mutagen mut0, double mu, int len0){
         super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1, OTU2, OTU3;
         seq_node OTU4, OTU5, OTU6, OTU7;
         seq_node node0, node1, node2, node3;
         seq_node node4, node5, node6, node7;
         OTU7  = new seq_node(mut0, 6, 0.125, len0);
         OTU6  = new seq_node(mut0, 3, 0.125, len0);
         node6 = new seq_node(0.125, OTU6, OTU7);
         OTU5  = new seq_node(mut0, 5, 0.25, len0);
         node5 = new seq_node(0.125, OTU5, node6);
         OTU4  = new seq_node(mut0, 4, 0.375, len0);
         node4 = new seq_node(0.125, OTU4, node5);
         OTU3  = new seq_node(mut0, 1, 0.5, len0);
         node3 = new seq_node(0.125, OTU3, node4);
         OTU2  = new seq_node(mut0, 2, 0.625, len0);
         node2 = new seq_node(0.125, OTU2, node3);
         OTU1  = new seq_node(mut0, 7, 0.75, len0);
         node1 = new seq_node(0.125, OTU1, node2);
         OTU0  = new seq_node(mut0, 0, 0.875, len0);
         root  = new seq_node(0.0, OTU0, node1);
         root.set_rate(mu);
    }
}
 
class Q extends CopyOfModelTree{ 
    public Q(mutagen mut0, double mu, int len0){
         super(mut0, (double) mu, len0);

// symmetry
        seq_node roots;
         seq_node OTUs0, OTUs1, OTUs2, OTUs3;
         seq_node OTUs4, OTUs5, OTUs6, OTUs7;
         seq_node nodes0, nodes1, nodes2, nodes3;
         seq_node nodes4, nodes5, nodes6, nodes7;
         OTUs7  = new seq_node(mut0, 7, 0.5, len0);
         OTUs6  = new seq_node(mut0, 6, 0.5, len0);
         nodes7  = new seq_node(0.1, OTUs6, OTUs7);
         OTUs5  = new seq_node(mut0, 5, 0.5, len0);
         OTUs4  = new seq_node(mut0, 4, 0.5, len0);
         nodes5  = new seq_node(0.1, OTUs4, OTUs5);
         OTUs3  = new seq_node(mut0, 3, 0.5, len0);
         OTUs2  = new seq_node(mut0, 2, 0.5, len0);
         nodes3  = new seq_node(0.1, OTUs2, OTUs3);
         OTUs1  = new seq_node(mut0, 1, 0.5, len0);
         OTUs0  = new seq_node(mut0, 0, 0.5, len0);
         nodes1  = new seq_node(0.1, OTUs0, OTUs1);
         nodes6  = new seq_node(0.1, nodes5, nodes7);
         nodes2  = new seq_node(0.1, nodes1, nodes3);
         roots  = new seq_node(0.1, nodes2, nodes6);

// asymmetry
        seq_node roota;
         seq_node OTUa0, OTUa1, OTUa2, OTUa3;
         seq_node OTUa4, OTUa5, OTUa6, OTUa7;
         seq_node nodea0, nodea1, nodea2, nodea3;
         seq_node nodea4, nodea5, nodea6, nodea7;
         OTUa7  = new seq_node(mut0, 8, 0.1, len0);
         OTUa6  = new seq_node(mut0, 9, 0.1, len0);
         nodea6 = new seq_node(0.1, OTUa6, OTUa7);
         OTUa5  = new seq_node(mut0, 10, 0.2, len0);
         nodea5 = new seq_node(0.1, OTUa5, nodea6);
         OTUa4  = new seq_node(mut0, 11, 0.3, len0);
         nodea4 = new seq_node(0.1, OTUa4, nodea5);
         OTUa3  = new seq_node(mut0, 12, 0.4, len0);
         nodea3 = new seq_node(0.1, OTUa3, nodea4);
         OTUa2  = new seq_node(mut0, 13, 0.5, len0);
         nodea2 = new seq_node(0.1, OTUa2, nodea3);
         OTUa1  = new seq_node(mut0, 14, 0.6, len0);
         nodea1 = new seq_node(0.1, OTUa1, nodea2);
         OTUa0  = new seq_node(mut0, 15, 0.7, len0);
         roota  = new seq_node(0.1, OTUa0, nodea1);

// long branches
         seq_node long1, long2;
         seq_node OTU1, OTU2;
         long1 = new seq_node(mut0, 16, 2, len0);
         long2 = new seq_node(mut0, 17, 2, len0);
         OTU1 =  new seq_node(0.1, long1, roots);
         OTU2 =  new seq_node(0.1, long2, roota);
         root  = new seq_node(0.0, OTU1, OTU2);
         root.set_rate(mu);
    }
}
 
class I extends CopyOfModelTree{ 
    public I(mutagen mut0, double mu, int len0){
         super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1;
         OTU0  = new seq_node(mut0, 0, 0.5, len0);
         OTU1  = new seq_node(mut0, 1, 0.5, len0);
         root  = new seq_node(0.0, OTU0, OTU1);
         root.set_rate(mu);
    }
}

 
class Y extends CopyOfModelTree{ 
    public Y(mutagen mut0, double mu, int len0){
         super(mut0, (double) mu, len0);
         seq_node OTU0, OTU1, OTU2, node0;
         OTU2  = new seq_node(mut0, 2, 0.5, len0);
         OTU1  = new seq_node(mut0, 1, 0.5, len0);
         node0 = new seq_node(0.5, OTU1, OTU2);
         OTU0  = new seq_node(mut0, 0, 1.0, len0);
         root  = new seq_node(0.0, node0, OTU0);
         root.set_rate(mu);
    }
}

class G extends CopyOfModelTree{ 
    public G(mutagen mut0, double mu, int len0){
         super(mut0, (double) mu, len0);
         double c = 0.001;

         seq_node Macaca = new seq_node(mut0, 1, c*20, len0);
         seq_node Human  = new seq_node(mut0, 0, c*20, len0);
         seq_node ape = new seq_node(c*10, Human, Macaca);

         seq_node Galago = new seq_node(mut0, 2, c*30, len0);
         seq_node monkey = new seq_node(c*70, ape, Galago);

         seq_node Mouse  = new seq_node(mut0, 3, c*35, len0);
         seq_node Rat    = new seq_node(mut0, 4, c*35, len0);
         seq_node rodent = new seq_node(c*65, Mouse, Rat);
         seq_node eutherian = new seq_node(c*30, monkey, rodent);

         seq_node Marsupial  = new seq_node(mut0, 5, c*130, len0);
         seq_node mammal = new seq_node(c*170, eutherian, Marsupial);

         seq_node Chicken = new seq_node(mut0, 6, c*300, len0);
         seq_node hot_animal = new seq_node(c*50, mammal, Chicken);

         seq_node Xenopus = new seq_node(mut0, 7, c*350, len0);
         seq_node tetrapod = new seq_node(c*50, hot_animal, Xenopus);

         seq_node Zebrafish = new seq_node(mut0, 8, c*400, len0);
         seq_node hard_bone = new seq_node(c*50, tetrapod, Zebrafish);

         seq_node Shark = new seq_node(mut0, 9, c*450, len0);
         seq_node fish = new seq_node(c*50, hard_bone, Shark);

         seq_node Lamprey = new seq_node(mut0, 10, c*500, len0);
         seq_node vertebrate = new seq_node(c*100, fish, Lamprey);

         seq_node Mollusca = new seq_node(mut0, 11, c*600, len0);
         seq_node soft_animal = new seq_node(c*100, vertebrate, Mollusca);

         seq_node Drosophila = new seq_node(mut0, 12, c*700, len0);
         seq_node higher_animal = new seq_node(c*250, soft_animal, Drosophila);

         seq_node Nematode  = new seq_node(mut0, 13, c*950, len0);
         seq_node animal = new seq_node(c*50, higher_animal, Nematode);

         seq_node Fungi  = new seq_node(mut0, 14, c*1000, len0);
         root = new seq_node(0.0, animal, Fungi);
         root.set_rate(mu);
    }
}
  
