package permutation3;

// Rat Feb 1st 2009 
// Kazuharu Misawa
// Algorithm is from Kimmel (2006)

import java.io.FileNotFoundException;
import java.io.IOException;

import io.fileload;
import primitive.SnpData;
import primitive.Snp_DataReader;
import primitive.pearson;
import primitive.primitive;
import primitive.Factorial;

public class RAT {
	public static void main(String[] args) throws FileNotFoundException,IOException {
		// genotype case-controlݒ
		// Iɂ͓o͂HvȂ΂ȂȂB
        // genotype 1   genotype 2
		//@o͍Hv20/Jan/2009
		//		int samplesize = (new Integer(args[0])).intValue();
//		int samplesize = 1000;
		int gen = 1000+0*1000; //S
		int burnin = 1000; //\
		// genotype case-controlݒ
		// o͉ǔ
		// genotype 1   genotype 2
        String[] data1 = fileload.loadLine0(args[0]); //t@CۂƓǂݍ
        SnpData[] snpData1 = new SnpData[data1.length];
        for(int j=0;j<data1.length;j++){
        	snpData1[j] = Snp_DataReader.DataReaderSetData(data1[j],2);
        }
        String[] data2 = fileload.loadLine0(args[1]);//t@CۂƓǂݍ
        SnpData[] snpData2 = new SnpData[data2.length];
        for(int j=0;j<data2.length;j++){
        	snpData2[j] = Snp_DataReader.DataReaderSetData(data2[j],2);
        }
        SnpData[][] data = Snp_DataReader.DataReaderMakeParallelData(snpData1,snpData2);
        int a = data[0][0].SNPdata.length;// number of haplotype copies (=sequences) in case
        int b = data[1][0].SNPdata.length;// number of haplotype copies (=sequences) in control

        //ŏprimitiveƈꏏ
        //ǁARAT@̍ő̓DNAz񂻂̂̂Ȃ
        //œʂo
        double Sobs=0;
        int top=0;
        int n = a + b; // sample size;
		int m = data[0].length; // z̒
		int[][][] Tj = new int[m][][];
		double[] Sj = new double[m];
		int[][] genotype = new int[m][m];
        for(int j=0;j<m;j++){
    		// ϑl􌻕\
        	int[] populationType = Snp_DataReader.populationType(data[0][j],data[1][j]);
    		Tj[j] = Snp_DataReader.DataReaderMakeTable(data[0][j],data[1][j],populationType);
    		Sj[j] = pearson.S(Tj[j]);
    		genotype[j] = genotype(data[0][j],data[1][j]);
    		// őXRATBvZłȂNaNɂȂ̂ł͏O
    		if( (Sj[j]!=Double.NaN) && (Sj[j]>Sobs) ) {
    			Sobs = Sj[j];
    			top  = j;
    		}
		}
		// ϑl̋􌻕\̃XRAvZ\
		System.out.print("Observed:");
		System.out.print(data[0][top].rsNumber);
		System.out.print("\t");
		System.out.print(Sobs);
		System.out.println();
		
		//炪Ⴄ
		if(Sobs<3.84){//vZ܂łȂsignificantȂ
			System.out.println("P>0.05");			
		}else{
			System.out.print(ratMain(data,Sobs,burnin,gen));
		}
		System.out.println();
	}

	public static int algorithmA(double[] numberOfDiInHj){
		// int GsamplerAlgorithmA(int ***Tj, double *Sj, int m)
		// ԂljɂȂmnumberOfDiInHj[j]ɔ
		int m = numberOfDiInHj.length;
		double sumOfNumberOfHj = 0;  
		// longdoubleɂB
		// ̊֐̒̌vZׂ͂double
		// ӂh
		for(int j=0;j<m;j++){
			sumOfNumberOfHj+=numberOfDiInHj[j];
		}
		double p = sumOfNumberOfHj*Math.random();
		for(int j=0;j<m;j++){
			if(p<numberOfDiInHj[j]) return j;
			p -= numberOfDiInHj[j];
		}
		return 0;
	}

	public static void algorithmB(Table T, double Score){ // call by pointer
		// Table GsamplerAlgorithmB(Table T, double Score)
		// creates new table following hyoergeometric distribution
		// 􉽕zɏ]MCMCŁAȑÕe[u玟̃e[u
		if( T.twoParts(Score) ){
			Table.markov2(T,Score);
		}else{
			Table.markov1(T,Score);
		}
	}

	public static int[] algorithmC(int[] genotype, Table T ){
		int[] di = conditionedDi(genotype, T.table());
		return di;
	}
	
	public static int Qvalue(int[][] genotype, int[] di, double Sobs){// 18
		int result = 0;
		int m = genotype.length;  // number of loci
		for(int j=0;j<m;j++){
			int[][] T = T(di, genotype[j]);
			double S = Table.PearsonScore(T);
			if (S>=Sobs) result++; // 18
		}
		return result;
	}	

	public static double numberOfDiInHj(Table table, double Sobs){
		double result = 0.0;
		int l = table.l();
		int u = table.u();
		for(int a1=l;a1<=u;a1++){
			int[][] T = table.newTable(a1);
			if( Table.inCj(Sobs, T) ){
				result += table.mu(T);
			}
		}
		return result;
	}
	
	public static int[] conditionedDi(int[] genotype, int[][] T){
		//int PermutationConditionedDi(int *genotype, int **T, int *result_type)
		//֋XケɈڂBύX͂Ȃ@Feb 1st, 2009 
		int a1=T[0][0];       int a2=T[0][1];  int a=a1+a2;// case
		int b1=T[1][0];       int b2=T[1][1];  int b=b1+b2;// control
        int n1=a1+b1;         int n2=a2+b2;    int n=n1+n2;
		int[][] num = new int[2][];
		num[0] = new int[n1];
		num[1] = new int[n2];
		int[] count = new int[2];
		for(int h=0;h<n;h++){
			int gen = genotype[h];
			num[gen][count[gen]]=h;
		    count[gen]++;
		}
		  //̈`q^ɑΉł悤
		  //Iɂ͊gB

		//ւ
		int[][] shuffle = new int[2][];
		int[] tmp = new int[2];
		tmp[0] = n1;
		tmp[1] = n2;
		for(int gen=0;gen<2;gen++){
			shuffle[gen] = primitive.omega(tmp[gen]);
		}
		    //Ŏӓxɍ킹casecontrolU
		int[] type = new int[n]; // case or control
		for(int gen=0;gen<2;gen++){
		    for(int h=0;h<tmp[gen];h++){
		         int tag = shuffle[gen][h];
		        if(h<T[0][gen]) { // Ȃ񂩋tˁH
		             type[tag]=0;
		        }else{
		             type[tag]=1;
		        }
		    }
		}
		return type;
	}

	public static int[][] T(int[] d, int[] genotype){//\2
		// int PermutationCalcT(int *d, int *genotype, int **result, int len)
		int[][] result = new int[2][2]; // default=0;
		int len = d.length;
		for(int h=0;h<len;h++){
			result[d[h]][genotype[h]]++;
		}
		/*
		 * result[0][0]control@&@genotype 1
		 * result[0][1]control@&@genotype 2
		 * result[1][0]case & genotype 1
		 * result[1][1]case & genotype 2
		 * XRAɂ͉eȂcasecontrolւĂ̂Œ
		 */
		return result;
	}	
	
	public static int[] genotype(SnpData snpData1, SnpData snpData2){
		char reference = Snp_DataReader.maximumNuc(snpData1);
		int[] genotype1 = Snp_DataReader.genotype(snpData1, reference);
		int[] genotype2 = Snp_DataReader.genotype(snpData2, reference);
		int a = genotype1.length; // number of cases
		int b = genotype2.length; // number of controls
		int n = a+b;// sample size
		int[] result = new int[n];
		for(int h=0;h<a;h++) result[h] = genotype1[h];
		for(int h=0;h<b;h++) result[h+a] = genotype2[h];
		return result;
	}

	public static double ratMain(SnpData[][] data, double Sobs, int generation, int burnin)  {

	        int a = data[0][0].SNPdata.length;// number of haplotype copies (=sequences) in case
	        int b = data[1][0].SNPdata.length;// number of haplotype copies (=sequences) in control
	
	        //ŏprimitiveƈꏏ
	        //ǁARAT@̍ő̓DNAz񂻂̂̂Ȃ
	        //œʂo
	        int top=0;
	        int n = a + b; // sample size;
			int m = data[0].length; // z̒
			int[][][] Tj = new int[m][][];
			double[] Sj = new double[m];
			int[][] genotype = new int[m][m];
	        for(int j=0;j<m;j++){
	    		// ϑl􌻕\
	        	int[] populationType = Snp_DataReader.populationType(data[0][j],data[1][j]);
	    		Tj[j] = Snp_DataReader.DataReaderMakeTable(data[0][j],data[1][j],populationType);
	    		Sj[j] = pearson.S(Tj[j]);
	    		genotype[j] = genotype(data[0][j],data[1][j]);
	    		// őXRATBvZłȂNaNɂȂ̂ł͏O
	    		if( (Sj[j]!=Double.NaN) && (Sj[j]>Sobs) ) {
	    			Sobs = Sj[j];
	    			top  = j;
	    		}
			}
	        int gen2 = 0;
			//炪Ⴄ
			if(Sobs<3.84){//vZ܂łȂsignificantȂ
				return Double.NaN;			
			}else{
				double sumOfQj = 0;
				double[] numberOfDiInHj = new double[m];
				for(int j=0;j<m;j++){
					Table T = new Table(Tj[j]);
					numberOfDiInHj[j] = numberOfDiInHj(T,Sobs);
					sumOfQj+=numberOfDiInHj[j];
				}
				double sumOfinvQj = 0;
				for(int i=0;i<burnin;i++){ // ̂Ă
					for(int j=0;j<m;j++){
						Table T = new Table(Tj[j]);
						algorithmB(T,Sobs);				
					}
				}
				for(int i=0;i<generation;i++){
					int j = algorithmA(numberOfDiInHj); // choose j
					Table T = new Table(Tj[j]);
					algorithmB(T,Sobs);
					int[] di = algorithmC(genotype[j], T);
	//				sumOfinvQj+=Q.Qvalue(genotype, di, Sobs);
	//				sumOfinvQj+=1/Q.Qvalue(genotype, di, Srat); // Nov21 2008
					double Qvalue = Qvalue(genotype, di, Sobs); // Jan20 2009
					if(Qvalue!=0){
						sumOfinvQj+=1/Qvalue;
						gen2++;
//					}else{
						//System.out.print("error");
					}
				}
				Factorial f = new Factorial(n);
				double logF = f.logCombination(n,a);
//				System.out.println(logF);
				return Math.exp( Math.log(sumOfQj)+Math.log(sumOfinvQj)-Math.log(gen2)-logF);			
			}
		}
}
