package primitive;

public class Factorial {
	double[] logFact;

	public Factorial(int maxSize){
		logFact = new double[maxSize+1];
		logFact[0]=0;
		for(int i=1;i<=maxSize;i++){
			logFact[i]=logFact[i-1]+Math.log(i);
		}
	}

	public double logFactorial(int n){ // n!
		if( n > logFact.length ) return Double.POSITIVE_INFINITY;
		return logFact[n];
	}

	public double factrial(int n){ // n!
		if( n > logFact.length ) return Double.POSITIVE_INFINITY;
		return Math.exp(logFact[n]);
	}
	
	public double logCombination(int n, int a){
		double logNfact = logFactorial(n);
		double logAfact = logFactorial(a);
		double logBfact = logFactorial((n-a)); 
		return logNfact - (logAfact+logBfact);
	}

	public double combination(int n, int a){
		return Math.exp(logCombination(n,a));
	}
}
