// Aug 10 2009
package main;
import io.SequenceLoad;
import io.charLoad;
import parameters.parameters;

public class MisawaKamatani {
	public static int extention = 20; // Altschul et al. 1990 JMB 215:405
	public char[] BWT;
	public int[] pos; // original postion
	public int[] C; // ꂼ̕xoĂ邩Ƃz
	public int[][] Occ; // Occ[i][j]jOioĂ邩Ƃz
	public static int max = 60;
	public int windowSize = 11;
	public int[] SA;
	public int[] SAinv;
	public int[] LF;
	public double [][] ScoreMatrix;
	public char[] target;
	
	public static void main(String[] args) {
    	long pre = System.currentTimeMillis();//ԑ
    	parameters params = new parameters(args);//
    	String[][][] seq = null;
    	char[] bwtOrg = null;
    	
    	Runtime runtime = Runtime.getRuntime();
    	 long max = runtime.maxMemory();
    	  long free = runtime.freeMemory();
    	  long beforeBWT = max - free;
    	//zload
    	try{
    		bwtOrg = charLoad.load(params);// load bwt file
    	   	max = runtime.maxMemory();
    		free = runtime.freeMemory();
    		long afterBWT = max - free;
    	    System.out.println(" memory used by bwt load is "+ (afterBWT-beforeBWT) );  
    	    seq = SequenceLoad.load(params);
    	   	max = runtime.maxMemory();
    		free = runtime.freeMemory();
    		long afterFasta = max - free;
    	    System.out.println(" memory used by fasta load is "+ (afterFasta-afterBWT) );  
    	}catch(Exception e){
    		System.out.println(e.getMessage());
    	}
    	
    	//*
    	MisawaKamatani BWT1 = new MisawaKamatani(bwtOrg);
        long start = System.currentTimeMillis();
        System.out.println("load\t" + (start - pre)+ "\tms" );
    	//System.out.println(BWT1.target);
    	//System.out.println(BWT1.BWT);
    	//seq=null;// test
    	   long afterFasta = 0;
    	if(seq!=null){
    //		System.out.println("data length\t"+seq[0][1][0].length());
    		//ȉ̓̕TCY͂ƂXs[h͉҂ł邩炠܂肢KvȂ
	        for(int i=0;i<seq[0][1].length;i++){
	        	String queryName = seq[0][0][i];
	        	String query     = seq[0][1][i];
	        	/*exactMatch̓eXgς݂RgAEg8/4
	        	tmp = BWT1.exactMatch(query);
	        	if( (tmp!=null) && (tmp.length>0) ) System.out.println("test of exact match\t"+tmp[0]);
	        	*/
	        	int len = query.length();
	    		for(int window=0;window+BWT1.windowSize<len;window+=BWT1.windowSize){
	    			//Ō͂܂肪o邩]ÕEChEɂ
	    			String word="";
	    			if(window+BWT1.windowSize<len){
	    				word = query.substring(window, window+BWT1.windowSize);
	    			}else{
	    				word = query.substring(window);
//	    				System.out.println(word);
	    			}
	    			int[] hitPos = BWT1.exactMatch(word);
	    			if(hitPos!=null){
	    				//͊ԈႢȂĂ
	    		    	for(int j=0;j<hitPos.length;j++){
	    					//System.out.println(word +" hit positions "+ hitPos[j]);
	    		        	double[] S = BWT1.getHighScoreRegion(hitPos[j],query,window);
	    		        	double[] tmp = new double[5];
	    		        	if(S!=null){
	    		            	tmp[0]=S[0];//score
	    		            	tmp[1]=S[1]+window;//start position on target
	    		            	tmp[2]=S[2]+window;//end position on target
	    		            	tmp[3]=hitPos[j]+S[1];//start position on target
	    		            	tmp[4]=hitPos[j]+S[2];//end position on target
	    		            	BWT1.output(tmp, params,queryName, query,10);
	    		        	} 
	    		        }
	    		    }
	    		}
        	}
   	        long finish = System.currentTimeMillis();
   	        System.out.println("search\t" + (finish - start)+ "\tms" );
    	}
    	/**/
	}

    public MisawaKamatani(char[] bwtwed){
		ScoreMatrix = initMatrix(100);

    	int len = bwtwed.length;
    	BWT = new char[len];
    	for(int i=0;i<len;i++){
    		char c = bwtwed[i];
    		if(c=='\0') c='$';
    		BWT[i]=c;
//    		System.out.print(BWT[i]);
//    		if(i%60==0) System.out.println();
    	}

    	Occ = new int[max][len]; // number of occurence of char
    	int[] count = new int[max];
    	C = new int[max];
    	for(int i=0;i<len;i++){
    		int n = charToInt(BWT[i]);
    		//System.out.print(BWT[i]);
    		count[n]++;
        	for(int j=0;j<max;j++){
        		Occ[j][i]=count[j];
        	}
    	}
    	//System.out.println();
    	C[0]=0;  // count of char 
    	for(int i=1;i<max;i++){
    		C[i]=C[i-1]+count[i-1];
    	}
    	// Ferragina and Manzini 2001 p3
    	pos = new int[len];
//    	int[] LF = new int[len+2];
    	LF = new int[len+2];
    	for(int i=0;i<len;i++){
    		int n = charToInt(BWT[i]);
    		LF[i] = C[n]+Occ[n][i]-1;
    	}
    	char[] F = new char[len];
    	int[] SA = new int[len];
    	for(int i=0;i<len;i++){
    		F[LF[i]]=BWT[i];
    		SA[LF[i]]=i;
    	}
   	
    	int p = 0;
    	for(int i=0;i<len;i++){
    		char c = BWT[p];
    		if(c=='$') break;// ending point
    		p = LF[p];//ǂĂ
    	}
    	target = new char[len];
    	for(int i=0;i<len;i++){
    		pos[p]=len-i-1;//IWi̒ł̈ʒu
    		target[pos[p]]=BWT[p];//̕𕜌// 2009/8/10
    		p = LF[p];
    	}
    }

	public void output(double[] result, parameters param,String queryName, String query, double threshold){
		String queryID="query";
		String  targetID="target";
		System.out.print(queryName);
		System.out.print("\t");
		System.out.print(param.fileName[0]);
		System.out.print("\t");
		int qStart = (int) result[1];
		int qEnd   = (int) result[2];
		int sStart = (int) result[3];
		int sEnd   = (int) result[4];
		int identity = percentMatch(query,qStart,qEnd,target,sStart,sEnd);
		System.out.print(identity);
		System.out.print("\t");
		int alignmentLength = (int) (result[2]-result[1]);
		System.out.print(alignmentLength);
		System.out.print("\t");
		System.out.print(qStart); // query 
		System.out.print("\t");
		System.out.print(qEnd);
		System.out.print("\t");
		System.out.print(sStart); // target 
		System.out.print("\t");
		System.out.print(sEnd);		
		System.out.print("\t");
		double Score = result[0];
		double E = E(query.length(),target.length,Score);
		System.out.print(E);		//	System.out.println(result.length);
		System.out.print("\t");
		System.out.print(Score);		//	System.out.println(result.length);
		System.out.println();

		//	System.out.println(result.length);
		//if(result[j][0]>threshold){
		//System.out.println(target.substring((int) result[j][1], (int) result[j][2]));
		//System.out.println(query.substring((int) result[j][3], (int) result[j][4]));
		//}
	}	

	
	public double E(int queryLen, int targetLen, double Score){ // Karlin and Altschul's E
		double k=0.1; //{̓V~[V猈߂
		int m=queryLen;
		int n=targetLen;
		double lambda=1.58;//taken from p63 in Korf 93
		return k*m*n*Math.exp(-lambda*Score);
		//̃ɂmatch =1; mismatch=-1;̂
	}
	
	public int percentMatch(String query, int qStart, int qEnd, char[] target, int tStart, int tEnd){
		int diff=0;
		int Ti = tStart;
		int count=0;
		for(int i=qStart;i<qEnd;i++){
			Ti++;
			count++;
			if(Ti>=target.length) break; // out of sequence
			if( query.charAt(i)!=target[Ti] ) diff++;
		}
		if(count>0) return (int) (100*diff/count);
		return 0;
	}
	
	public void show(){
    	System.out.println(BWT.length);
		for(int i=0;i<BWT.length;i++){
			System.out.print(BWT[i]);
		}
		System.out.println();
	}
	
	public static double[][] initMatrix(int max){
		double[][] result = new double[max][max];
		for(int i=0;i<max;i++){
			for(int j=0;j<max;j++){
				result[i][j]=-1;
			}
			result[i][i]=1;
		}
		return result;
	}
	
    public int charToInt1(char c){
    	String alphabet = "$,ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";
    	//alphabet = "$,ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";
    //	alphabet = "$abcdefghijklmnopqrst";
    	//alphabet = "$acgt";
    	//At@xbg̑IѕŌʂςBłH//܂܂Ă
    	max = alphabet.length();
    	int result = alphabet.indexOf(c);
    	if (result<0) result = 0; // no char
    	return result;
    }
    
    public static int charToInt(char c){
    	int result = ((int) c) - ((int) '@');
    	if(result<0) result=0;
    	if(result>=max) result=max-1;
    	return result;
    }
    
    public int[] exactMatch(String query){
    	try{
        	// Ferragina and Manzini 2001 p5
        	int len = query.length();
        	int sp=0; // start point
        	int ep=len-1;//end point
    		char c = query.charAt(len-1); // the last char
    		int n = charToInt(c);
    		sp = C[n];
    		ep = C[n+1]-1;
    		if(sp>=ep) return null; // no char
        	for(int i=len-2;i>=0;i--){
        		c = query.charAt(i); // i-th char
        		n = charToInt(c);
        		sp = C[n]+Occ[n][sp-1];//java͍ŏ낾
        		ep = C[n]+Occ[n][ep]-1;//8/4/2009CAR͓
        	}
        	int range = ep-sp+1;// ̃qbg
        	int[] result = new int[range];
        	for(int i=0;i<range;i++){
        		result[i] = pos[sp+i]+1;//8/4/2009+1mF
        		if(result[i]==BWT.length) result[i]=0;
        		//ĂȂƓvꍇɂȂ
        	}
        	return result;
    	}catch(Exception e){
    		return null;
    	}
    }

	public double[] getHighScoreRegion(int targetPos, String query, int queryPos){
		int queryLen  = query.length();
		int targetLen = target.length;
		double Stmp=0;
		double Smax=0;
		int maxStart=0;
		int maxEnd=0;
		int tsuishiCount=0;// ǎ󂯂
		//System.out.println("target\t"+target);
		//System.out.println("query\t"+queryLen+query);
		//OɐL΂
		for(int i=0;i>-queryLen;i--){
			if(i+targetPos<0)  break; // targetz̑OɏoĂ܂
			if(i+queryPos<0) break; // queryz̑OɏoĂ܂
			char g = target[i+targetPos];
			char q = query.charAt(i+queryPos);
			/*
			System.out.print(g);
			System.out.print("\t");
			System.out.print(q);
			System.out.print("\t");
			*/
			Stmp += ScoreMatrix[charToInt(g)][charToInt(q)];
			tsuishiCount++;
			if(tsuishiCount>extention) break;
			if(Stmp>Smax){
			     Smax=Stmp;
			     maxStart = i;
			     tsuishiCount=0;  //ǎōi
			}/*
			System.out.print("" +					"mae2\t");
			System.out.println(Stmp);/**/
		}
		//ɐL΂
		for(int i=1;i<queryLen;i++){
			if(i+targetPos>=target.length) break; // ͈͊O
			if(i+queryPos>=query.length())   break; // ͈͊OɃoO
			char g = target[i+targetPos];
			char q = query.charAt(i+queryPos);
			/*
			System.out.print(g);
			System.out.print("\t");
			System.out.print(q);
			System.out.print("\t");/**/
			Stmp += ScoreMatrix[charToInt(g)][charToInt(q)];
			tsuishiCount++;
			if(tsuishiCount>extention) break;
			if(Stmp>Smax){
			     Smax=Stmp;
			     maxEnd = i;
			     tsuishiCount=0;  //ǎōi
			}/*
			System.out.print("ushiro\t");
			System.out.println(Stmp);/**/
		}
		double[] result = new double[3];
		result[0] = Smax; // maximum score
		result[1] = maxStart; // maximum score
		result[2] = maxEnd; // maximum score
		return result;
	}	
}