// Aug 10 2009
package main;
import io.SequenceLoad;
import io.charLoad;
import parameters.parameters;

public class MisawaKamatani {
	public static int extention = 20; // Altschul et al. 1990 JMB 215:405
//	public char[] BWT;[Jϐ
	public int[] pos; // original postion
	public int[] C; // ꂼ̕xoĂ邩Ƃz
	public int[][] Occ; // Occ[i][j]jOioĂ邩Ƃz
	public static int max = 6;//  $=0, u=U=T=t=1, c=C=2, a=A=3, g=G=4, others=5
	public int windowSize = 11;
//	public int[] SA;
//	public int[] SAinv;
//	public int[] LF;//֐
	public double [][] ScoreMatrix;
	public char[] target;
	public int dataSize;
	
	public static void main(String[] args) {
    	long pre = System.currentTimeMillis();//ԑ
    	parameters params = new parameters(args);//
    	String[][][] seq = null;
    	char[] bwtOrg = null;
    	
    	Runtime runtime = Runtime.getRuntime();
    	 long max = runtime.maxMemory();
    	  long free = runtime.freeMemory();
    	  long beforeBWT = max - free;
    	//zload
    	try{
    		bwtOrg = charLoad.load(params);// load bwt file
    	   	max = runtime.maxMemory();
    		free = runtime.freeMemory();
    		long afterBWT = max - free;
    	    System.out.println(params.bwtName[0] +" memory used by bwt load is\t"+ (afterBWT-beforeBWT) );  
    	    seq = SequenceLoad.load(params);
    	   	max = runtime.maxMemory();
    		free = runtime.freeMemory();
    		long afterFasta = max - free;
    	    System.out.println(params.bwtName[0] +" memory used by fasta is\t"+ (afterFasta-afterBWT) );  
    	}catch(Exception e){
    		System.out.println(e.getMessage());
    	}
    	
    	//*
		free = runtime.freeMemory();
		long beforeConstructor = max - free;
    	MisawaKamatani BWT1 = new MisawaKamatani(bwtOrg);
		free = runtime.freeMemory();
		long afterConstructor = max - free;
	    System.out.println(params.bwtName[0] + " memory used by constructor is\t"+ (afterConstructor-beforeConstructor) );  
        long start = System.currentTimeMillis();
        System.out.println(params.bwtName[0] +"\tload\t" + (start - pre)+ "\tms" );
    	//System.out.println(BWT1.target);
    	//System.out.println(BWT1.BWT);
    	//seq=null;// test

		int wordLen = BWT1.windowSize;
		char[] word= new char[wordLen]; // window̒̕
    	double[] tmp = new double[5];
      if(seq!=null){
	        for(int i=0;i<seq[0][1].length;i++){
	        	String queryName = seq[0][0][i];
	        	String query     = seq[0][1][i];
	        	int len = query.length();
	        	double threshold = 0.01; //̓f[^TCYӎȂĂ
	    		for(int window=0;window+BWT1.windowSize<len;window+=BWT1.windowSize){
	    			//Ō͂܂肪o邩]ÕEChEɂ
	    			//͂ݏo܂͖@8/11
    				for(int wordCharPos=0;wordCharPos<wordLen;wordCharPos++){
    					word[wordCharPos] = query.charAt(wordCharPos+window);
	    			}
	    			int[] hitPos = BWT1.exactMatch(word);
	    			if(hitPos!=null){
	    				//͊ԈႢȂĂ
	    		    	for(int j=0;j<hitPos.length;j++){
	    					//System.out.println(word +" hit positions "+ hitPos[j]);
	    		        	double[] S = BWT1.getHighScoreRegion(hitPos[j],query,window);
	    		        	if( (S!=null)&&(S[3]<threshold)){
	    		            	tmp[0]=S[0];//score
	    		            	tmp[1]=S[1]+window;//start position on query
	    		            	tmp[2]=S[2]+window;//end position on query
	    		            	tmp[3]=hitPos[j]+S[1];//start position on target
	    		            	tmp[4]=hitPos[j]+S[2];//end position on target
	    		            	BWT1.output(tmp, params,queryName, query,10);
	    		            	window += S[2]; //qbgƂ܂ňړ
	    		        	} 
	    		        }
	    		    }
	    		}
        	}
   	        long finish = System.currentTimeMillis();
   	        System.out.println(params.bwtName[0] +"\tsearch\t" + (finish - start)+ "\tms" );
    	}
    	/**/
	}

    public MisawaKamatani(char[] bwtwed){
		ScoreMatrix = initMatrix(100);
		dataSize = bwtwed.length;
    	int len = dataSize;
//    	char[] BWT = new char[len];// [Jϐɂ1%炢
    	char[] BWT = bwtwed;// [Jϐɂ1%炢
    	Occ = new int[max][len]; // number of occurence of char
    	int[] count = new int[max];
    	C = new int[max];
    	for(int i=0;i<len;i++){
    		int n = charToInt(BWT[i]);
    		//System.out.print(BWT[i]);
    		count[n]++;
        	for(int j=0;j<max;j++){
        		Occ[j][i]=count[j];
        	}
    	}
    	//System.out.println();
    	C[0]=0;  // count of char 
    	for(int i=1;i<max;i++){
    		C[i]=C[i-1]+count[i-1];
    	}
    	// Ferragina and Manzini 2001 p3

    	int p = 0;
    	for(int i=0;i<len;i++){
    		char c = BWT[p];
    		if(c=='$') break;// ending point
    		p = LF(p,BWT);//LF[p];//ǂĂ
    	}
    	target = new char[len];
    	pos = new int[len];
    	for(int i=0;i<len;i++){
    		pos[p]=len-i-1;//IWi̒ł̈ʒu
    		target[pos[p]]=BWT[p];//̕𕜌// 2009/8/10
    		p = LF(p,BWT);//LF[p];;
    	}
    }
    
    public int LF(int i, char[] BWT){
		int n = charToInt(BWT[i]);
		return C[n]+Occ[n][i]-1;
    }

	public void output(double[] result, parameters param,String queryName, String query, double threshold){
		String queryID="query";
		String  targetID="target";
		System.out.print(queryName);
		System.out.print("\t");
		System.out.print(param.bwtName[0]);
		System.out.print("\t");
		int qStart = (int) result[1];
		int qEnd   = (int) result[2];
		int sStart = (int) result[3];
		int sEnd   = (int) result[4];
		int identity = percentMatch(query,qStart,qEnd,target,sStart,sEnd);
		System.out.print(identity);
		System.out.print("\t");
		int alignmentLength = (int) (result[2]-result[1]);
		System.out.print(alignmentLength);
		System.out.print("\t");
		System.out.print(qStart); // query 
		System.out.print("\t");
		System.out.print(qEnd);
		System.out.print("\t");
		System.out.print(sStart); // target 
		System.out.print("\t");
		System.out.print(sEnd);		
		System.out.print("\t");
		double Score = result[0];
		double E = E(query.length(),target.length,Score);
		System.out.print(E);		//	System.out.println(result.length);
		System.out.print("\t");
		System.out.print(Score);		//	System.out.println(result.length);
		System.out.println();

		//	System.out.println(result.length);
		//if(result[j][0]>threshold){
		//System.out.println(target.substring((int) result[j][1], (int) result[j][2]));
		//System.out.println(query.substring((int) result[j][3], (int) result[j][4]));
		//}
	}	

	

	/*
	public void show(){
    	System.out.println(dataSize);
		for(int i=0;i<dataSize;i++){
			System.out.print(BWT[i]);
		}
		System.out.println();
	}
	*/
	
	public static double[][] initMatrix(int max){
		double[][] result = new double[max][max];
		for(int i=0;i<max;i++){
			for(int j=0;j<max;j++){
				result[i][j]=-1;
			}
			result[i][i]=1;
		}
		return result;
	}
	
	//$=0, u=U=T=t=1, c=C=2, a=A=3, g=G=4, others=5
    public static int charToInt(char c){
    	//8/11ŁBcharintɂBB
    	//ȂȂĂ܂B
    	//At@xbgɂƍB
//		if(c=='u') return 1;
//		if(c=='U') return 1;
    	if(c=='$') return 0;
		if(c=='A') return 1;
		if(c=='a') return 1;
		if(c=='c') return 2;
		if(c=='C') return 2;
		if(c=='G') return 3;
		if(c=='g') return 3;
		if(c=='T') return 4;
		if(c=='T') return 4;
    	return 5;
    }
	/*
    public static int charToInt(char c){
    	//8/11ŁBcharintɂBB
    	int result = ((int) c) - ((int) '@');
    	if(result<0) result=0;
    	if(result>=max) result=max-1;
    	return result;
    }
    */
	
    public int[] exactMatch(char[] query){
    	try{
        	// Ferragina and Manzini 2001 p5
        	int len = query.length;
        	int sp=0; // start point
        	int ep=len-1;//end point
    		char c = query[len-1]; // the last char
    		int n = charToInt(c);
    		sp = C[n];
    		ep = C[n+1]-1;
    		if(sp>=ep) return null; // no char
        	for(int i=len-2;i>=0;i--){
        		c = query[i]; // i-th char
        		n = charToInt(c);
        		sp = C[n]+Occ[n][sp-1];//java͍ŏ낾
        		ep = C[n]+Occ[n][ep]-1;//8/4/2009CAR͓
        	}
        	int range = ep-sp+1;// ̃qbg
        	int[] result = new int[range];
        	for(int i=0;i<range;i++){
        		result[i] = pos[sp+i]+1;//8/4/2009+1mF
        		if(result[i]==dataSize) result[i]=0;
        		//ĂȂƓvꍇɂȂ
        	}
        	return result;
    	}catch(Exception e){
    		return null;
    	}
    }

	public double[] getHighScoreRegion(int targetPos, String query, int queryPos){
		int queryLen  = query.length();
		int targetLen = target.length;
		double Stmp=0;
		double Smax=0;
		int maxStart=0;
		int maxEnd=0;
		int tsuishiCount=0;// ǎ󂯂
		//System.out.println("target\t"+target);
		//System.out.println("query\t"+queryLen+query);
		//OɐL΂
		for(int i=0;i>-queryLen;i--){
			if(i+targetPos<0)  break; // targetz̑OɏoĂ܂
			if(i+queryPos<0) break; // queryz̑OɏoĂ܂
			char g = target[i+targetPos];
			char q = query.charAt(i+queryPos);
			/*
			System.out.print(g);
			System.out.print("\t");
			System.out.print(q);
			System.out.print("\t");
			*/
			Stmp += ScoreMatrix[charToInt(g)][charToInt(q)];
			tsuishiCount++;
			if(tsuishiCount>extention) break;
			if(Stmp>Smax){
			     Smax=Stmp;
			     maxStart = i;
			     tsuishiCount=0;  //ǎōi
			}/*
			System.out.print("" +					"mae2\t");
			System.out.println(Stmp);/**/
		}
		//ɐL΂
		for(int i=1;i<queryLen;i++){
			if(i+targetPos>=target.length) break; // ͈͊O
			if(i+queryPos>=query.length())   break; // ͈͊OɃoO
			char g = target[i+targetPos];
			char q = query.charAt(i+queryPos);
			/*
			System.out.print(g);
			System.out.print("\t");
			System.out.print(q);
			System.out.print("\t");/**/
			Stmp += ScoreMatrix[charToInt(g)][charToInt(q)];
			tsuishiCount++;
			if(tsuishiCount>extention) break;
			if(Stmp>Smax){
			     Smax=Stmp;
			     maxEnd = i;
			     tsuishiCount=0;  //ǎōi
			}/*
			System.out.print("ushiro\t");
			System.out.println(Stmp);/**/
		}
		double[] result = new double[4];
		result[0] = Smax; // maximum score
		result[1] = maxStart; // start of the region of maximum score
		result[2] = maxEnd; // end of the region of maximum score
		result[3] = E(queryLen,target.length,Smax); // E-value
		return result;
	}	
	
	public double E(int queryLen, int targetLen, double Score){ // Karlin and Altschul's E
		double k=0.1; //{̓V~[V猈߂
		int m=queryLen;
		int n=targetLen;
		double lambda=1.58;//taken from p63 in Korf 93
		return k*m*n*Math.exp(-lambda*Score);
		//̃ɂmatch =1; mismatch=-1;̂
	}
	
	public int percentMatch(String query, int qStart, int qEnd, char[] target, int tStart, int tEnd){
		int diff=0;
		int Ti = tStart;
		int count=0;
		for(int i=qStart;i<qEnd;i++){
			Ti++;
			count++;
			if(Ti>=target.length) break; // out of sequence
			if( query.charAt(i)!=target[Ti] ) diff++;
		}
		if(count>0) return (int) (100*diff/count);
		return 0;
	}
}