/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import paraselene.Page;
import paraselene.supervisor.NullPage;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageID;
import paraselene.supervisor.SandBox;
import paraselene.supervisor.TransactionSequencer;

public abstract class PageFactory
extends Thread {
    int page_cnt;
    int include_cnt;
    private HashMap<Integer, Class<? extends Page>> class_def = new HashMap();
    private HashMap<Integer, LinkedList<Page>> pre_load = new HashMap();
    private HashMap<Integer, Date> last_access = new HashMap();
    private ArrayList<String> alias_list = new ArrayList();
    private ArrayList<Boolean> full_match = new ArrayList();
    private HashMap<String, Integer> alias = new HashMap();
    ArrayList<PageID> page_list = new ArrayList();
    volatile boolean running_f = true;

    public Information getInformation() {
        return new Information(this);
    }

    public PageFactory(int stock_cnt, int inc_cnt) {
        Option.entry(this);
        this.page_cnt = stock_cnt;
        this.include_cnt = inc_cnt;
        this.setDaemon(true);
        this.setPriority(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefine(PageID id, Class<? extends Page> cls) throws Exception {
        Page page = null;
        LinkedList<Page> que = new LinkedList<Page>();
        HashMap<Integer, Class<? extends Page>> hashMap = this.class_def;
        synchronized (hashMap) {
            this.page_list.add(id);
            this.class_def.put(id.getID(), cls);
            this.last_access.put(id.getID(), new Date());
            page = cls.newInstance();
            if (Option.isReleaseMode()) {
                que.offer(page);
            }
            this.pre_load.put(id.getID(), que);
            String uri = page.getAliasURI();
            if (uri == null) {
                return;
            }
            if (uri.length() < 4) {
                throw new Exception(uri + "(alias of " + id.toString() + ") are less than 4 characters.");
            }
            if (this.alias.put(uri, id.getID()) != null) {
                throw new Exception(uri + "(alias of " + id.toString() + ") is duplicate.");
            }
            boolean flag = TransactionSequencer.EXTENSION.equals(uri.substring(uri.length() - 3));
            this.full_match.add(flag);
            if (flag) {
                this.alias_list.add(uri);
                return;
            }
            int size = this.alias_list.size();
            for (int i = 0; i < size; ++i) {
                if (this.full_match.get(i).booleanValue() || this.alias_list.get(i).indexOf(uri) != 0 && uri.indexOf(this.alias_list.get(i)) != 0) continue;
                throw new Exception(uri + "(alias of " + id.toString() + ") conflict with " + this.alias_list.get(i) + ".");
            }
            this.alias_list.add(uri);
        }
    }

    public abstract NullPage getNullPage();

    public Page getPage(PageID id) {
        return this.getPage(id.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Page getPage(int id) {
        Class<? extends Page> cls = null;
        HashMap<Integer, Class<? extends Page>> hashMap = this.class_def;
        synchronized (hashMap) {
            LinkedList<Page> que = this.pre_load.get(id);
            this.last_access.put(id, new Date());
            int cnt = que.size();
            if (cnt > 0) {
                this.class_def.notifyAll();
                return que.poll();
            }
            cls = this.class_def.get(id);
        }
        try {
            if (!SandBox.isSafeFreeMemory()) {
                Thread.sleep(1200L);
            }
            Page pg = cls.newInstance();
            return pg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    Page getPage(String uri) {
        String[] path = uri.split("#");
        if (path.length == 0) {
            path = new String[]{uri};
        }
        if ((path = path[0].split("\\?")).length == 0) {
            path = new String[]{uri};
        }
        path = path[0].split("/");
        int list_cnt = this.alias_list.size();
        for (int i = 0; i < path.length; ++i) {
            Integer id;
            if (path[i].length() < 4 || !TransactionSequencer.EXTENSION.equals(path[i].substring(path[i].length() - 3))) continue;
            String hit = null;
            for (int j = 0; j < list_cnt; ++j) {
                String name = this.alias_list.get(j);
                boolean full = this.full_match.get(j);
                if (full ? !name.equals(path[i]) : name.length() >= path[i].length() || !name.equals(path[i].substring(0, name.length()))) continue;
                hit = name;
                if (j == 0 || list_cnt <= 1) continue;
                this.alias_list.set(j, this.alias_list.set(j - 1, name));
                this.full_match.set(j, this.full_match.set(j - 1, full));
            }
            if (hit == null || (id = this.alias.get(hit)) == null) continue;
            return this.getPage(id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnPage(Page page) {
        if (page instanceof NullPage) {
            return;
        }
        if (!page.isInitialized()) {
            return;
        }
        HashMap<Integer, Class<? extends Page>> hashMap = this.class_def;
        synchronized (hashMap) {
            LinkedList<Page> que = this.pre_load.get(page.getID().getID());
            if (que == null) {
                return;
            }
            if (que.indexOf(page) >= 0) {
                return;
            }
            if (Option.isReleaseMode()) {
                que.offerFirst(page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running_f) {
            HashMap<Integer, Class<? extends Page>> hashMap = this.class_def;
            synchronized (hashMap) {
                Date now = new Date();
                try {
                    for (Integer key : this.pre_load.keySet()) {
                        LinkedList<Page> que = this.pre_load.get(key);
                        Date lac = this.last_access.get(key);
                        int cnt = que.size();
                        if (cnt > 0 && !Option.isReleaseMode()) {
                            que.clear();
                            continue;
                        }
                        if (now.getTime() - lac.getTime() > 300000L || !SandBox.isSafeFreeMemory()) {
                            if (cnt <= 1) continue;
                            que.poll();
                            continue;
                        }
                        if (que.size() < this.page_cnt && Option.isReleaseMode()) {
                            Class<? extends Page> cls = this.class_def.get(key);
                            for (int j = 0; j < this.include_cnt; ++j) {
                                Page pg = cls.newInstance();
                                que.offer(pg);
                                this.class_def.wait(1L);
                            }
                        }
                        this.class_def.wait(10L);
                    }
                    this.class_def.wait(60000L);
                }
                catch (Exception e) {
                    try {
                        this.class_def.wait(1000L);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class Information {
        public final String name;
        public final int page_cnt;
        public final int include_cnt;
        public final PageInformation[] page;

        Information(PageFactory pf) {
            this.name = pf.getClass().getName();
            this.page_cnt = pf.page_cnt;
            this.include_cnt = pf.include_cnt;
            ArrayList<PageInformation> info = new ArrayList<PageInformation>();
            int cnt = pf.page_list.size();
            for (int i = 0; i < cnt; ++i) {
                info.add(new PageInformation(pf.page_list.get(i)));
            }
            this.page = info.toArray(new PageInformation[0]);
        }
    }

    public class PageInformation {
        public final String page_id;
        public final String class_name;
        public final int loaded;
        public final Date access_date;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PageInformation(PageID id) {
            this.page_id = id.toString();
            HashMap hashMap = PageFactory.this.class_def;
            synchronized (hashMap) {
                this.class_name = ((Class)PageFactory.this.class_def.get(id.getID())).getName();
                this.loaded = ((LinkedList)PageFactory.this.pre_load.get(id.getID())).size();
                this.access_date = (Date)PageFactory.this.last_access.get(id.getID());
            }
        }
    }
}

