/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.io.*;
import java.net.*;


/**
 * HTML構造。
 */
public abstract class HTMLPart implements Serializable {
	/**
	 * 文字列種別。
	 */
	public enum StringMode {
		/**
		 * プレーンテキスト。
		 */
		PLAIN,
		/**
		 * TEXTAREAタグ内の文字列。
		 */
		TEXTAREA,
		/**
		 * TABLEタグ内の文字列。
		 */
		TABLE,
		/**
		 * タグ属性値の文字列。
		 */
		ATTRIBUTE,
		/**
		 * BODYタグ内の文字列。
		 */
		BODY;

		private static final long serialVersionUID = 1L;
	};

	/**
	 * 所属先ページ。
	 */
	public Page	embed = null;

	protected HTMLPart() {}

	/**
	 * 文字列化。
	 * @return 文字列化。
	 */
	public String toString() {
		try {
			return toString( StringMode.PLAIN );
		}
		catch( Exception e ) {
			return e.toString();
		}
	}

	/**
	 * テキスト化。
	 * @param mode 出力モード。
	 * @return 文字列。
	 */
	public abstract String toString( StringMode mode );

	/**
	 * 出力。
	 * @param w ライター。
	 * @param mode 出力モード。
	 */
	public void write( PrintWriter w, StringMode mode ) {
		String	str = toString( mode );
		if ( str == null )	return;
		w.print( str );
	}

	/**
	 * 複製の作成。
	 * @return 複製。
	 */
	public abstract HTMLPart getReplica();
}


