/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.dyna;

import java.net.*;
import java.io.*;
import java.util.*;
import paraselene.mockup.*;

class ResponseReader extends ByteArrayInputStream {
	ResponseReader( byte[] b ) {
		super( b );
	}
	ResponseReader( byte[] b, int o, int l ) {
		super( b, o, l );
	}
	void open() {
		pos = 0;
	}
	byte[] getBytes() {
		byte[]	ret = new byte[count];
		for ( int i = 0; i < count; i++ ) {
			ret[i] = buf[i];
		}
		return ret;
	}
}

class RequestWriter extends ByteArrayOutputStream {
	URI	uri;
	RequestWriter( URI u ) {
		super( 4096 );
		uri = u;
	}
	public void close() throws IOException {
		super.close();
		Cache.add( uri, new ResponseReader( buf, 0, count ) );
	}
}

class Request extends CacheRequest {
	URI	uri;
	RequestWriter	writer;
	Request( URI u ) {
		uri = u;
		writer = new RequestWriter( u );
	}
	public OutputStream getBody() throws IOException {
		return writer;
	}
	public void abort() {
		Cache.delete( uri );
	}
}

class Response extends CacheResponse {
	ResponseReader		body;
	Map<String, List<String>>	head;
	Response( ResponseReader b, Map<String, List<String>> h ) {
		body = b;
		head = h;
	}
	public Map<String, List<String>> getHeaders() throws IOException {
		return head;
	}
	public InputStream getBody() throws IOException {
		body.open();
		return body;
	}
}

class Cache extends ResponseCache {
	private static HashMap<URI, ResponseReader>	body_map =
		new HashMap<URI, ResponseReader>();
	private static HashMap<URI, Map<String, List<String>>>	head_map =
		new HashMap<URI, Map<String, List<String>>>();

	private static final String BODY = "paraselene.body.";
	private static final String HEAD = "paraselene.head.";

	private static File[] getSaveFile( String path ) {
		String	user = System.getProperty( "user.name" );
		return new File[] {
			new File( path + File.separator + BODY + user ),
			new File( path + File.separator + HEAD + user )
		};
	}

	static void save() throws Exception {
		String	path = Param.DTD.get();
		if ( path == null )	return;
		if ( !new File( path ).exists() ) {
			Linker.readme.echoln( "WARNING: " + path + " doesn't exist." );
			return;
		}
		File[]	f = getSaveFile( path );
		File	body = f[0];
		File	head = f[1];

		HashMap<URI, byte[]>	tmp = new HashMap<URI, byte[]>();
		for ( URI uri: body_map.keySet() ) {
			tmp.put( uri, body_map.get( uri ).getBytes() );
		}
		ObjectOutputStream	out = new ObjectOutputStream(
			new FileOutputStream( body )
		);
		out.writeObject( tmp );
		out.close();

		out = new ObjectOutputStream( new FileOutputStream( head ) );
		out.writeObject( head_map );
		out.close();
	}

	static void add( URI uri, ResponseReader data ) {
		synchronized( body_map ) {
			body_map.put( uri, data );
		}
		StringBuffer	buf = new StringBuffer( "\"" );
		buf = buf.append( uri.toString() );
		buf = buf.append( "\" was cached." );
		Linker.readme.echoln( buf.toString() );
	}

	static void delete( URI uri ) {
		synchronized( head_map ) {
			head_map.remove( uri );
		}
	}

	@SuppressWarnings("unchecked")
	public static void init() throws Exception {
		ResponseCache.setDefault( new Cache() );

		String	path = Param.DTD.get();
		if ( path == null )	return;

		File[]	f = getSaveFile( path );
		File	body = f[0];
		File	head = f[1];
		if ( !body.exists() || !head.exists() ) {
			Linker.readme.echoln( "DTD cache doesn't exist in " + path );
			return;
		}
		Linker.readme.echoln( "DTD cache loaded from " + path );

		ObjectInputStream	in = new ObjectInputStream(
			new FileInputStream( body )
		);
		HashMap<URI, byte[]>	tmp = (HashMap<URI, byte[]>)in.readObject();
		in.close();
		for ( URI uri: tmp.keySet() ) {
			body_map.put( uri, new ResponseReader( tmp.get( uri ) ) );
		}

		in = new ObjectInputStream( new FileInputStream( head ) );
		head_map = (HashMap<URI, Map<String, List<String>>>)in.readObject();
		in.close();
	}

	private Cache() {}

	private static boolean isGet( URI u ) {
		String	last = u.getPath();
		int	len = last.length() - 4;
		if ( len < 0 )	return false;
		last = last.substring( len );
		if ( last.equals( ".dtd" ) )	return true;
		if ( last.equals( ".ent" ) )	return true;
		return false;
	}

	public CacheResponse get( URI u, String method, Map<String, List<String>> m )
	throws IOException {
		if ( !isGet( u ) )	return null;
		if ( !"GET".equalsIgnoreCase( method ) )	return null;
		ResponseReader		b = null;
		Map<String, List<String>>	head = null;
		synchronized( body_map ) {
			b = body_map.get( u );
		}
		synchronized( head_map ) {
			head = head_map.get( u );
		}
		if ( b == null || head == null ) {
			CacheRequest	req = null;
			try {
				ResponseCache.setDefault( null );
				URL	url = new URL( u.toString() );
				URLConnection	r_conn = url.openConnection();
				if ( !(r_conn instanceof HttpURLConnection) )	return null;
				HttpURLConnection	conn = (HttpURLConnection)r_conn;
				conn.setRequestProperty( "User-Agent", Param.USER_AGENT.get() );
				conn.connect();
				if ( (conn.getResponseCode()) / 100 != 2 )	return null;
				req = put( u, conn );
				OutputStream	out = req.getBody();
				BufferedInputStream	in = new BufferedInputStream(
					conn.getInputStream()
				);
				byte[]	buf = new byte[4096];
				while ( true ) {
					int	size = in.read( buf );
					if ( size <= 0 )	break;
					out.write( buf, 0, size );
				}
				in.close();
				out.close();
				synchronized( body_map ) {
					b = body_map.get( u );
				}
				synchronized( head_map ) {
					head = head_map.get( u );
				}
				ResponseCache.setDefault( new Cache() );
			}
			catch( Exception e ) {
				return null;
			}
		}
		return new Response( b, head );
	}

	public CacheRequest put( URI u, URLConnection conn ) throws IOException {
		if ( !isGet( u ) )	return null;
		if ( conn instanceof HttpURLConnection ) {
			HttpURLConnection	http = (HttpURLConnection)conn;
			if ( !"GET".equalsIgnoreCase( http.getRequestMethod() ) )	return null;
		}
		else	return null;
		synchronized( head_map ) {
			head_map.put( u, conn.getHeaderFields() );
		}
		return new Request( u );
	}
}

