/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.dyna;


import paraselene.tag.*;

/**
 * 独自タグクラスの割り当て。<br>
 * paraselene はこのインターフェイスのメソッドを通し、ユーザーが作成したクラスの
 * 生成または、生成用のソースファイルを取得します。<br>
 * ここで得られたインスタンス、またはソースファイルに続けて、Paraselene が全ての
 * 属性値を setAttribute します。<br>
 * このため、ユーザー側は setAttribute を行う必要はありません。
 */
public interface GrantTag {
	/**
	 * スケルトンソース用 new 文字列の取得。
	 * @return new 文字列。
	 * @exception DynamicPageException 継続不可能なエラーが発生した場合。
	 */
	String getNewString() throws DynamicPageException;

	/**
	 * インスタンスの生成。
	 * @return 新しいインスタンス。
	 * @exception DynamicPageException 継続不可能なエラーが発生した場合。
	 */
	Tag getNewTag() throws DynamicPageException;
}

