/*
 * Decompiled with CFR 0.152.
 */
package paraselene.mockup;

enum LineSeparator {
    CR("cr", "\r"),
    LF("lf", "\n"),
    CRLF("crlf", "\r\n"),
    LFCR("lfcr", "\n\r");

    private static LineSeparator use;
    private String name;
    private String code;

    private LineSeparator(String n2, String c) {
        this.name = n2;
        this.code = c;
    }

    static String getOSName() {
        LineSeparator[] ls = LineSeparator.values();
        for (int i = 0; i < ls.length; ++i) {
            if (!ls[i].code.equals(System.getProperty("line.separator"))) continue;
            return ls[i].name;
        }
        return LineSeparator.CRLF.name;
    }

    static boolean setUse(String name) {
        LineSeparator[] ls = LineSeparator.values();
        for (int i = 0; i < ls.length; ++i) {
            if (!ls[i].name.equals(name)) continue;
            use = ls[i];
            return true;
        }
        return false;
    }

    static String getUse() {
        if (use == null) {
            return System.getProperty("line.separator");
        }
        return LineSeparator.use.code;
    }
}

